/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.BatchDoubleSupplier;
import com.github.akurilov.commons.math.Random;
import java.io.IOException;

public class RangeDefinedDoubleSupplier
implements BatchDoubleSupplier {
    private final double min;
    private final double range;
    private final Random rnd;

    public RangeDefinedDoubleSupplier(long seed, double min, double max) {
        this.rnd = new Random(seed);
        this.min = min;
        this.range = max - min;
    }

    @Override
    public final double getAsDouble() {
        if (this.range < 0.0) {
            return this.rnd.nextDouble();
        }
        return this.min + this.range * this.rnd.nextDouble();
    }

    @Override
    public final int get(double[] buffer, int limit) {
        int _limit = Math.min(buffer.length, limit);
        if (this.range < 0.0) {
            for (int i = 0; i < _limit; ++i) {
                buffer[i] = this.rnd.nextDouble();
            }
        } else {
            for (int i = 0; i < _limit; ++i) {
                buffer[i] = this.min + this.range * this.rnd.nextDouble();
            }
        }
        return _limit;
    }

    @Override
    public final long skip(long count) {
        for (long i = 0L; i < count; ++i) {
            this.rnd.nextDouble();
        }
        return count;
    }

    @Override
    public final void reset() {
        this.rnd.reset();
    }

    @Override
    public void close() throws IOException {
    }
}

