/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.RangeDefinedLongSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public final class RangeDefinedLongFormattingSupplier
extends RangeDefinedLongSupplier
implements RangeDefinedSupplier<Long> {
    private final NumberFormat format;

    public RangeDefinedLongFormattingSupplier(long seed, long min, long max, String formatStr) {
        super(seed, min, max);
        this.format = formatStr == null || formatStr.isEmpty() ? null : new DecimalFormat(formatStr);
    }

    @Override
    public String get() {
        return this.format == null ? Long.toString(this.getAsLong()) : this.format.format(this.getAsLong());
    }

    @Override
    public int get(List<String> buffer, int limit) {
        long[] numbers = new long[limit];
        int n = super.get(numbers, limit);
        if (this.format == null) {
            for (int i = 0; i < n; ++i) {
                buffer.add(Long.toString(numbers[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                buffer.add(this.format.format(numbers[i]));
            }
        }
        return n;
    }

    @Override
    public Long value() {
        return this.getAsLong();
    }

    @Override
    public final void close() throws IOException {
        super.close();
    }
}

