/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.BatchLongSupplier;
import com.github.akurilov.commons.math.Random;
import java.io.IOException;

public class RangeDefinedLongSupplier
implements BatchLongSupplier {
    private final long min;
    private final long range;
    private final Random rnd;

    public RangeDefinedLongSupplier(long seed, long min, long max) {
        this.rnd = new Random(seed);
        this.min = min;
        this.range = max - min + 1L;
    }

    @Override
    public final long getAsLong() {
        if (this.range < 1L) {
            return this.rnd.nextLong();
        }
        return this.min + this.rnd.nextLong(this.range);
    }

    @Override
    public final int get(long[] buffer, int limit) {
        int _limit = Math.min(buffer.length, limit);
        if (this.range < 0L) {
            for (int i = 0; i < _limit; ++i) {
                buffer[i] = this.rnd.nextLong();
            }
        } else {
            for (int i = 0; i < _limit; ++i) {
                buffer[i] = this.min + this.rnd.nextLong(this.range);
            }
        }
        return _limit;
    }

    @Override
    public final long skip(long count) {
        for (long i = 0L; i < count; ++i) {
            this.rnd.nextLong();
        }
        return count;
    }

    @Override
    public final void reset() {
        this.rnd.reset();
    }

    @Override
    public void close() throws IOException {
    }
}

