/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.common.supply.BasicPatternDefinedSupplier;
import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import com.emc.mongoose.api.common.supply.SupplierFactory;

public final class RangePatternDefinedSupplier
extends BasicPatternDefinedSupplier {
    private String[] segments;
    private static final ThreadLocal<StringBuilder> THREAD_SB_0 = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private static final ThreadLocal<StringBuilder> THREAD_SB_1 = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private static final ThreadLocal<StringBuilder> STRING_BULDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public RangePatternDefinedSupplier(String pattern) throws OmgShootMyFootException {
        super(pattern);
    }

    public RangePatternDefinedSupplier(String pattern, SupplierFactory<String, ? extends BatchSupplier<String>> supplierFactory) throws OmgShootMyFootException {
        super(pattern, supplierFactory);
    }

    private void setSegments(String[] segments) {
        this.segments = segments;
    }

    @Override
    protected final void initialize() throws OmgShootMyFootException {
        int patternSymbolsNum = RangePatternDefinedSupplier.countPatternSymbols(this.getPattern());
        if (patternSymbolsNum > 0) {
            this.setSuppliers(new BatchSupplier[patternSymbolsNum]);
            this.setSegments(new String[patternSymbolsNum + 1]);
            StringBuilder segmentsBuilder = THREAD_SB_0.get();
            segmentsBuilder.setLength(0);
            StringBuilder patternBuilder = THREAD_SB_1.get();
            patternBuilder.setLength(0);
            patternBuilder.append(this.getPattern());
            int segmentCounter = 0;
            for (int j = 0; j < patternSymbolsNum; ++j) {
                int i = 0;
                while (patternBuilder.charAt(i) != '%') {
                    segmentsBuilder.append(patternBuilder.charAt(i));
                    ++i;
                }
                this.segments[segmentCounter] = segmentsBuilder.toString();
                segmentsBuilder.setLength(0);
                patternBuilder.delete(0, i + 1);
                this.addExpressionParams(patternBuilder, segmentCounter);
                ++segmentCounter;
            }
            this.segments[patternSymbolsNum] = patternBuilder.toString();
        }
    }

    public static int countPatternSymbols(String pattern) {
        int counter = 0;
        if (!pattern.isEmpty()) {
            int lastPatternIndex = pattern.length() - 1;
            if (pattern.charAt(lastPatternIndex) == '%') {
                throw new IllegalArgumentException();
            }
            char[] patternChars = pattern.toCharArray();
            for (int i = 0; i < lastPatternIndex; ++i) {
                if (patternChars[i] != '%') continue;
                ++counter;
                if (patternChars[i + 1] != '%') continue;
                throw new IllegalArgumentException();
            }
        }
        return counter;
    }

    private void addExpressionParams(StringBuilder expression, int index) throws OmgShootMyFootException {
        char type = expression.charAt(0);
        String seed = this.initParameter(expression, RangeDefinedSupplier.SEED_BRACKETS);
        String format = this.initParameter(expression, FORMAT_BRACKETS);
        String range = this.initParameter(expression, RangeDefinedSupplier.RANGE_BRACKETS);
        expression.delete(0, 1);
        this.getSuppliers()[index] = this.getSupplierFactory().createSupplier(type, seed, format, range);
    }

    public String toString() {
        StringBuilder result = STRING_BULDER.get();
        result.setLength(0);
        result.append("Generators: ");
        if (this.getSuppliers() != null) {
            for (BatchSupplier<String> input : this.getSuppliers()) {
                result.append(input.getClass().getName()).append(";");
            }
        }
        result.append("\n");
        result.append("Segments: ");
        if (this.segments != null) {
            for (String segment : this.segments) {
                result.append(segment).append(";");
            }
        }
        result.append("\n");
        return result.toString();
    }

    @Override
    protected final String assembleOutputString(StringBuilder result) {
        for (int i = 0; i < this.segments.length - 1; ++i) {
            result.append(this.segments[i]);
            if (this.getSuppliers()[i] == null) continue;
            result.append((String)this.getSuppliers()[i].get());
        }
        result.append(this.segments[this.segments.length - 1]);
        return result.toString();
    }
}

