/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.FilePathSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedDateFormattingSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedDoubleFormattingSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedLongFormattingSupplier;
import com.emc.mongoose.api.common.supply.SupplierFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang.time.DateUtils;

public final class StringSupplierFactory<G extends BatchSupplier<String>>
implements SupplierFactory<String, G> {
    private static final StringSupplierFactory<? extends BatchSupplier<String>> INSTANCE = new StringSupplierFactory();

    private StringSupplierFactory() {
    }

    public static StringSupplierFactory<? extends BatchSupplier<String>> getInstance() {
        return INSTANCE;
    }

    @Override
    public G createSupplier(char type, String seedStr, String formatStr, String rangeStr) throws OmgShootMyFootException {
        long seed = System.nanoTime() ^ System.currentTimeMillis();
        if (seedStr != null && !seedStr.isEmpty()) {
            try {
                seed = Long.parseLong(seedStr);
            }
            catch (NumberFormatException e) {
                throw new OmgShootMyFootException("Seed value is not a 64 bit integer: \"" + seedStr + "\"");
            }
        }
        switch (type) {
            case 'd': {
                long min = Long.MIN_VALUE;
                long max = Long.MAX_VALUE;
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = LONG_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        min = Long.parseLong(matcher.group(1));
                        max = Long.parseLong(matcher.group(2));
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new RangeDefinedLongFormattingSupplier(seed, min, max, formatStr);
            }
            case 'f': {
                double min = 0.0;
                double max = 1.0;
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = DOUBLE_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        min = Double.parseDouble(matcher.group(1));
                        max = Double.parseDouble(matcher.group(2));
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new RangeDefinedDoubleFormattingSupplier(seed, min, max, formatStr);
            }
            case 'D': {
                Date min = new Date(0L);
                Date max = new Date();
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = DATE_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        try {
                            min = DateUtils.parseDate((String)matcher.group(1), (String[])INPUT_DATE_FMT_STRINGS);
                            max = DateUtils.parseDate((String)matcher.group(6), (String[])INPUT_DATE_FMT_STRINGS);
                        }
                        catch (ParseException e) {
                            throw new OmgShootMyFootException("Failed to parse the pattern");
                        }
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new RangeDefinedDateFormattingSupplier(seed, min, max, formatStr);
            }
            case 'p': {
                return (G)new FilePathSupplier(seed, formatStr);
            }
        }
        throw new OmgShootMyFootException("Unknown format type: '" + type + "'");
    }
}

