/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply.async;

import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import com.emc.mongoose.api.common.supply.async.AsyncUpdatingValueSupplier;
import com.github.akurilov.commons.concurrent.InitCallable;
import com.github.akurilov.commons.concurrent.Initializable;
import com.github.akurilov.commons.math.Random;
import com.github.akurilov.coroutines.CoroutinesProcessor;
import java.io.IOException;
import java.util.List;

public abstract class AsyncRangeDefinedSupplierBase<T>
implements Initializable,
RangeDefinedSupplier<T> {
    protected final Random rnd;
    private final T minValue;
    private final T range;
    private final BatchSupplier<T> newValueSupplier;

    protected AsyncRangeDefinedSupplierBase(CoroutinesProcessor coroutinesProcessor, long seed, T minValue, T maxValue) throws OmgDoesNotPerformException {
        this.rnd = new Random(seed);
        this.minValue = minValue;
        this.range = this.computeRange(minValue, maxValue);
        this.newValueSupplier = new AsyncUpdatingValueSupplier<T>(coroutinesProcessor, minValue, new InitCallable<T>(){

            public boolean isInitialized() {
                return AsyncRangeDefinedSupplierBase.this.isInitialized();
            }

            public T call() throws Exception {
                return AsyncRangeDefinedSupplierBase.this.rangeValue();
            }
        });
    }

    protected abstract T computeRange(T var1, T var2);

    protected abstract T rangeValue();

    protected abstract T singleValue();

    protected abstract String toString(T var1);

    protected final T minValue() {
        return this.minValue;
    }

    protected final T range() {
        return this.range;
    }

    @Override
    public final T value() {
        return this.newValueSupplier.get();
    }

    @Override
    public final String get() {
        return this.toString(this.value());
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        int count;
        for (count = 0; count < limit; ++count) {
            buffer.add(this.get());
        }
        return count;
    }

    @Override
    public final long skip(long count) {
        return this.newValueSupplier.skip(count);
    }

    @Override
    public final void reset() {
        this.newValueSupplier.reset();
    }

    public boolean isInitialized() {
        return true;
    }

    @Override
    public final void close() throws IOException {
        this.newValueSupplier.close();
    }
}

