/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply.async;

import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.supply.BasicUpdatingValueSupplier;
import com.github.akurilov.commons.concurrent.InitCallable;
import com.github.akurilov.coroutines.Coroutine;
import com.github.akurilov.coroutines.CoroutinesProcessor;
import com.github.akurilov.coroutines.ExclusiveCoroutineBase;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncUpdatingValueSupplier<T>
extends BasicUpdatingValueSupplier<T> {
    private static final Logger LOG = Logger.getLogger(AsyncUpdatingValueSupplier.class.getName());
    private final Coroutine updateTask;

    public AsyncUpdatingValueSupplier(CoroutinesProcessor coroutinesProcessor, T initialValue, final InitCallable<T> updateAction) throws OmgDoesNotPerformException {
        super(initialValue, null);
        if (updateAction == null) {
            throw new NullPointerException("Argument should not be null");
        }
        this.updateTask = new ExclusiveCoroutineBase(coroutinesProcessor){

            protected final void invokeTimedExclusively(long startTimeNanos) {
                try {
                    AsyncUpdatingValueSupplier.this.lastValue = updateAction.call();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to execute the value update action", e);
                    e.printStackTrace(System.err);
                }
            }

            protected final void doClose() throws IOException {
                AsyncUpdatingValueSupplier.this.lastValue = null;
            }
        };
        this.updateTask.start();
    }

    @Override
    public final T get() {
        return (T)this.lastValue;
    }

    @Override
    public final int get(List<T> buffer, int limit) {
        int count;
        for (count = 0; count < limit; ++count) {
            buffer.add(this.lastValue);
        }
        return count;
    }

    @Override
    public long skip(long count) {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.updateTask.close();
    }

    public static abstract class InitializedCallableBase<T>
    implements InitCallable<T> {
        public final boolean isInitialized() {
            return true;
        }
    }
}

