/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.codahale.metrics.UniformSnapshot;
import com.emc.mongoose.api.metrics.CustomMeter;
import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.metrics.MetricsListener;
import com.emc.mongoose.api.metrics.ResumableUserTimeClock;
import com.emc.mongoose.api.model.io.IoType;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntSupplier;

public final class BasicMetricsContext
implements Comparable<BasicMetricsContext>,
MetricsContext {
    private final Clock clock = new ResumableUserTimeClock();
    private final Histogram reqDuration;
    private final Histogram respLatency;
    private final Histogram actualConcurrency;
    private volatile Snapshot reqDurSnapshot;
    private volatile Snapshot respLatSnapshot;
    private volatile Snapshot actualConcurrencySnapshot;
    private final LongAdder reqDurationSum;
    private final LongAdder respLatencySum;
    private volatile long lastDurationSum = 0L;
    private volatile long lastLatencySum = 0L;
    private volatile int lastConcurrency;
    private final CustomMeter throughputSuccess;
    private final CustomMeter throughputFail;
    private final CustomMeter reqBytes;
    private final long ts;
    private volatile long tsStart = -1L;
    private volatile long prevElapsedTime = 0L;
    private final String stepId;
    private final IoType ioType;
    private final IntSupplier actualConcurrencyGauge;
    private final int driverCount;
    private final int concurrency;
    private final int thresholdConcurrency;
    private final SizeInBytes itemDataSize;
    private final boolean stdOutColorFlag;
    private final boolean avgPersistFlag;
    private final boolean sumPersistFlag;
    private final boolean perfDbResultsFileFlag;
    private final long outputPeriodMillis;
    private volatile long lastOutputTs = 0L;
    private volatile MetricsContext.Snapshot lastSnapshot = null;
    private volatile MetricsListener metricsListener = null;
    private volatile MetricsContext thresholdMetricsCtx = null;
    private volatile boolean thresholdStateExitedFlag = false;

    public BasicMetricsContext(String stepId, IoType ioType, IntSupplier actualConcurrencyGauge, int driverCount, int concurrency, int thresholdConcurrency, SizeInBytes itemDataSize, int updateIntervalSec, boolean stdOutColorFlag, boolean avgPersistFlag, boolean sumPersistFlag, boolean perfDbResultsFileFlag) {
        this.stepId = stepId;
        this.ioType = ioType;
        this.actualConcurrencyGauge = actualConcurrencyGauge;
        this.driverCount = driverCount;
        this.concurrency = concurrency;
        this.thresholdConcurrency = thresholdConcurrency > 0 ? thresholdConcurrency : Integer.MAX_VALUE;
        this.itemDataSize = itemDataSize;
        this.stdOutColorFlag = stdOutColorFlag;
        this.avgPersistFlag = avgPersistFlag;
        this.sumPersistFlag = sumPersistFlag;
        this.perfDbResultsFileFlag = perfDbResultsFileFlag;
        this.outputPeriodMillis = TimeUnit.SECONDS.toMillis(updateIntervalSec);
        this.respLatency = new Histogram((Reservoir)new SlidingWindowReservoir(1000));
        this.respLatSnapshot = this.respLatency.getSnapshot();
        this.respLatencySum = new LongAdder();
        this.reqDuration = new Histogram((Reservoir)new SlidingWindowReservoir(1000));
        this.reqDurSnapshot = this.reqDuration.getSnapshot();
        this.actualConcurrency = new Histogram((Reservoir)(this.outputPeriodMillis > 0L ? new SlidingTimeWindowArrayReservoir(this.outputPeriodMillis, TimeUnit.MILLISECONDS, this.clock) : new UniformReservoir(1000)));
        this.actualConcurrencySnapshot = this.actualConcurrency.getSnapshot();
        this.reqDurationSum = new LongAdder();
        this.throughputSuccess = new CustomMeter(this.clock, updateIntervalSec);
        this.throughputFail = new CustomMeter(this.clock, updateIntervalSec);
        this.reqBytes = new CustomMeter(this.clock, updateIntervalSec);
        this.ts = System.nanoTime();
    }

    @Override
    public final void start() {
        this.tsStart = System.currentTimeMillis();
        this.throughputSuccess.resetStartTime();
        this.throughputFail.resetStartTime();
        this.reqBytes.resetStartTime();
    }

    @Override
    public final boolean isStarted() {
        return this.tsStart > -1L;
    }

    @Override
    public final void markElapsedTime(long millis) {
        this.prevElapsedTime = millis;
    }

    @Override
    public void close() throws IOException {
        this.prevElapsedTime = System.currentTimeMillis() - this.tsStart;
        this.tsStart = -1L;
        this.lastSnapshot = null;
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.close();
            this.thresholdMetricsCtx = null;
        }
    }

    @Override
    public final void markSucc(long size, long duration, long latency) {
        this.throughputSuccess.mark();
        this.reqBytes.mark(size);
        if (latency > 0L && duration > latency) {
            this.reqDuration.update(duration);
            this.respLatency.update(latency);
            this.reqDurationSum.add(duration);
            this.respLatencySum.add(latency);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(size, duration, latency);
        }
    }

    @Override
    public final void markPartSucc(long size, long duration, long latency) {
        this.reqBytes.mark(size);
        if (latency > 0L && duration > latency) {
            this.reqDuration.update(duration);
            this.respLatency.update(latency);
            this.reqDurationSum.add(duration);
            this.respLatencySum.add(latency);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(size, duration, latency);
        }
    }

    @Override
    public final void markSucc(long count, long bytes, long[] durationValues, long[] latencyValues) {
        this.throughputSuccess.mark(count);
        this.reqBytes.mark(bytes);
        for (long duration : durationValues) {
            this.reqDuration.update(duration);
            this.reqDurationSum.add(duration);
        }
        for (long latency : latencyValues) {
            this.respLatency.update(latency);
            this.respLatencySum.add(latency);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markSucc(count, bytes, durationValues, latencyValues);
        }
    }

    @Override
    public final void markPartSucc(long bytes, long[] durationValues, long[] latencyValues) {
        this.reqBytes.mark(bytes);
        for (long duration : durationValues) {
            this.reqDuration.update(duration);
            this.reqDurationSum.add(duration);
        }
        for (long latency : latencyValues) {
            this.respLatency.update(latency);
            this.respLatencySum.add(latency);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markPartSucc(bytes, durationValues, latencyValues);
        }
    }

    @Override
    public final void markFail() {
        this.throughputFail.mark();
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail();
        }
    }

    @Override
    public final void markFail(long count) {
        this.throughputFail.mark(count);
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.markFail(count);
        }
    }

    @Override
    public final String getStepId() {
        return this.stepId;
    }

    @Override
    public final IoType getIoType() {
        return this.ioType;
    }

    @Override
    public final int getDriverCount() {
        return this.driverCount;
    }

    @Override
    public final int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public final int getConcurrencyThreshold() {
        return this.thresholdConcurrency;
    }

    @Override
    public final int getActualConcurrency() {
        this.lastConcurrency = this.actualConcurrencyGauge.getAsInt();
        this.actualConcurrency.update(this.lastConcurrency);
        if (System.currentTimeMillis() - this.lastOutputTs > 10L) {
            this.actualConcurrencySnapshot = this.actualConcurrency.getSnapshot();
        }
        return this.lastConcurrency;
    }

    @Override
    public final SizeInBytes getItemDataSize() {
        return this.itemDataSize;
    }

    @Override
    public final boolean getStdOutColorFlag() {
        return this.stdOutColorFlag;
    }

    @Override
    public final boolean getAvgPersistFlag() {
        return this.avgPersistFlag;
    }

    @Override
    public final boolean getSumPersistFlag() {
        return this.sumPersistFlag;
    }

    @Override
    public final boolean getPerfDbResultsFileFlag() {
        return this.perfDbResultsFileFlag;
    }

    @Override
    public final long getOutputPeriodMillis() {
        return this.outputPeriodMillis;
    }

    @Override
    public final long getLastOutputTs() {
        return this.lastOutputTs;
    }

    @Override
    public final void setLastOutputTs(long ts) {
        this.lastOutputTs = ts;
    }

    @Override
    public final void refreshLastSnapshot() {
        long currElapsedTime;
        long currentTimeMillis = System.currentTimeMillis();
        long l = currElapsedTime = this.tsStart > 0L ? currentTimeMillis - this.tsStart : 0L;
        if (currentTimeMillis - this.lastOutputTs > 10L) {
            if (this.lastDurationSum != this.reqDurationSum.sum()) {
                this.lastDurationSum = this.reqDurationSum.sum();
                this.reqDurSnapshot = this.reqDuration.getSnapshot();
            }
            if (this.lastLatencySum != this.respLatencySum.sum()) {
                this.lastLatencySum = this.respLatencySum.sum();
                this.respLatSnapshot = this.respLatency.getSnapshot();
            }
        }
        this.lastSnapshot = new BasicSnapshot(this.throughputSuccess.getCount(), this.throughputSuccess.getLastRate(), this.throughputFail.getCount(), this.throughputFail.getLastRate(), this.reqBytes.getCount(), this.reqBytes.getLastRate(), this.tsStart, this.prevElapsedTime + currElapsedTime, this.lastConcurrency, this.actualConcurrencySnapshot.getMean(), this.lastDurationSum, this.lastLatencySum, this.reqDurSnapshot, this.respLatSnapshot);
        if (this.metricsListener != null) {
            this.metricsListener.notify(this.lastSnapshot);
        }
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.refreshLastSnapshot();
        }
    }

    @Override
    public final MetricsContext.Snapshot getLastSnapshot() {
        if (this.lastSnapshot == null) {
            this.refreshLastSnapshot();
        }
        return this.lastSnapshot;
    }

    @Override
    public final void setMetricsListener(MetricsListener metricsListener) {
        this.metricsListener = metricsListener;
    }

    @Override
    public final boolean isThresholdStateEntered() {
        return this.thresholdMetricsCtx != null && this.thresholdMetricsCtx.isStarted();
    }

    @Override
    public final void enterThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx != null) {
            throw new IllegalStateException("Nested metrics context already exists");
        }
        this.thresholdMetricsCtx = new BasicMetricsContext(this.stepId, this.ioType, this.actualConcurrencyGauge, this.driverCount, this.concurrency, 0, this.itemDataSize, (int)TimeUnit.MILLISECONDS.toSeconds(this.outputPeriodMillis), this.stdOutColorFlag, this.avgPersistFlag, this.sumPersistFlag, this.perfDbResultsFileFlag);
        this.thresholdMetricsCtx.start();
    }

    @Override
    public final MetricsContext getThresholdMetrics() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Nested metrics context is not exist");
        }
        return this.thresholdMetricsCtx;
    }

    @Override
    public final boolean isThresholdStateExited() {
        return this.thresholdStateExitedFlag;
    }

    @Override
    public final void exitThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Threshold state was not entered");
        }
        try {
            this.thresholdMetricsCtx.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        this.thresholdStateExitedFlag = true;
    }

    @Override
    public final int compareTo(BasicMetricsContext other) {
        return Long.compare(this.ts, other.ts);
    }

    public final String toString() {
        return "MetricsContext(" + this.ioType.name() + '-' + this.concurrency + 'x' + this.driverCount + '@' + this.stepId + ")";
    }

    protected static final class BasicSnapshot
    implements MetricsContext.Snapshot {
        private final long countSucc;
        private final double succRateLast;
        private final long countFail;
        private final double failRateLast;
        private final long countByte;
        private final double byteRateLast;
        private final long[] durValues;
        private transient Snapshot durSnapshot = null;
        private final long[] latValues;
        private transient Snapshot latSnapshot = null;
        private final long sumDur;
        private final long sumLat;
        private final long startTime;
        private final long elapsedTime;
        private final int actualConcurrencyLast;
        private final double actualConcurrencyMean;

        public BasicSnapshot(long countSucc, double succRateLast, long countFail, double failRateLast, long countByte, double byteRateLast, long startTime, long elapsedTime, int actualConcurrencyLast, double actualConcurrencyMean, long sumDur, long sumLat, Snapshot durSnapshot, Snapshot latSnapshot) {
            this.countSucc = countSucc;
            this.succRateLast = succRateLast;
            this.countFail = countFail;
            this.failRateLast = failRateLast;
            this.countByte = countByte;
            this.byteRateLast = byteRateLast;
            this.sumDur = sumDur;
            this.sumLat = sumLat;
            this.startTime = startTime;
            this.elapsedTime = elapsedTime;
            this.actualConcurrencyLast = actualConcurrencyLast;
            this.actualConcurrencyMean = actualConcurrencyMean;
            this.durSnapshot = durSnapshot;
            this.durValues = durSnapshot.getValues();
            this.latSnapshot = latSnapshot;
            this.latValues = latSnapshot.getValues();
        }

        @Override
        public final long getSuccCount() {
            return this.countSucc;
        }

        @Override
        public final double getSuccRateMean() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.countSucc / (double)this.elapsedTime;
        }

        @Override
        public final double getSuccRateLast() {
            return this.succRateLast;
        }

        @Override
        public final long getFailCount() {
            return this.countFail;
        }

        @Override
        public final double getFailRateMean() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.countFail / (double)this.elapsedTime;
        }

        @Override
        public final double getFailRateLast() {
            return this.failRateLast;
        }

        @Override
        public final long getByteCount() {
            return this.countByte;
        }

        @Override
        public final double getByteRateMean() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.countByte / (double)this.elapsedTime;
        }

        @Override
        public final double getByteRateLast() {
            return this.byteRateLast;
        }

        @Override
        public final long getDurationMin() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return this.durSnapshot.getMin();
        }

        @Override
        public final long getDurationLoQ() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return (long)this.durSnapshot.getValue(0.25);
        }

        @Override
        public final long getDurationMed() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return (long)this.durSnapshot.getValue(0.5);
        }

        @Override
        public final long getDurationHiQ() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return (long)this.durSnapshot.getValue(0.75);
        }

        @Override
        public final long getDurationMax() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return this.durSnapshot.getMax();
        }

        @Override
        public final long getDurationSum() {
            return this.sumDur;
        }

        @Override
        public final double getDurationMean() {
            if (this.durSnapshot == null) {
                this.durSnapshot = new UniformSnapshot(this.durValues);
            }
            return this.durSnapshot.getMean();
        }

        @Override
        public final long getLatencyMin() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return this.latSnapshot.getMin();
        }

        @Override
        public final long getLatencyLoQ() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return (long)this.latSnapshot.getValue(0.25);
        }

        @Override
        public final long getLatencyMed() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return (long)this.latSnapshot.getValue(0.5);
        }

        @Override
        public final long getLatencyHiQ() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return (long)this.latSnapshot.getValue(0.75);
        }

        @Override
        public final long getLatencyMax() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return this.latSnapshot.getMax();
        }

        @Override
        public final long getLatencySum() {
            return this.sumDur;
        }

        @Override
        public final double getLatencyMean() {
            if (this.latSnapshot == null) {
                this.latSnapshot = new UniformSnapshot(this.latValues);
            }
            return this.latSnapshot.getMean();
        }

        @Override
        public final long getStartTimeMillis() {
            return this.startTime;
        }

        @Override
        public final long getElapsedTimeMillis() {
            return this.elapsedTime;
        }

        @Override
        public final int getActualConcurrencyLast() {
            return this.actualConcurrencyLast;
        }

        @Override
        public final double getActualConcurrencyMean() {
            return this.actualConcurrencyMean;
        }
    }
}

