/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.EWMA;
import com.codahale.metrics.Metric;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class CustomMeter
implements Metric {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    private final EWMA rateAvg;
    private final LongAdder count = new LongAdder();
    private final Clock clock;
    private long startTime;
    private AtomicLong lastTick = new AtomicLong();

    public CustomMeter(Clock clock, int periodSec) {
        double ps = periodSec > 0 ? (double)periodSec : 10.0;
        boolean intervalSecs = true;
        this.rateAvg = new EWMA(1.0 - Math.exp(-1.0 / ps), 1L, TimeUnit.SECONDS);
        this.clock = clock;
        this.startTime = clock.getTick();
        this.lastTick.set(this.startTime);
    }

    public void resetStartTime() {
        this.startTime = this.clock.getTick();
        this.lastTick.set(this.startTime);
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.count.add(n);
        this.rateAvg.update(n);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.rateAvg.tick();
            }
        }
    }

    public long getCount() {
        return this.count.sum();
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        double elapsed = this.clock.getTick() - this.startTime;
        return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public double getLastRate() {
        this.tickIfNecessary();
        return this.rateAvg.getRate(TimeUnit.SECONDS);
    }
}

