/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.emc.mongoose.api.metrics.MeterMBean;
import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.model.svc.ServiceUtil;
import java.io.IOException;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class Meter
implements MeterMBean {
    private final MetricsContext metricsCtx;
    private final ObjectName objectName;
    private long startTimeMillis;
    private long succCount;
    private double succRateMean;
    private double succRateLast;
    private long failCount;
    private double failRateMean;
    private double failRateLast;
    private long byteCount;
    private double byteRateMean;
    private double byteRateLast;
    private long elapsedTimeMillis;
    private int actualConcurrencyLast;
    private double actualConcurrencyMean;
    private long durationSum;
    private long latencySum;
    private long durationMin;
    private long durationLoQ;
    private long durationMed;
    private long durationHiQ;
    private long durationMax;
    private long latencyMin;
    private long latencyLoQ;
    private long latencyMed;
    private long latencyHiQ;
    private long latencyMax;
    private double durationMean;
    private double latencyMean;

    public Meter(MetricsContext metricsCtx) throws MalformedObjectNameException {
        this.metricsCtx = metricsCtx;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("stepId", metricsCtx.getStepId());
        props.put("loadType", metricsCtx.getIoType().name());
        props.put("storageDriverCount", Integer.toString(metricsCtx.getDriverCount()));
        props.put("storageDriverConcurrency", Integer.toString(metricsCtx.getConcurrency()));
        this.objectName = new ObjectName(METRICS_DOMAIN, props);
        metricsCtx.setMetricsListener(this);
        try {
            ServiceUtil.MBEAN_SERVER.registerMBean(this, this.objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
    }

    @Override
    public final void close() throws IOException {
        this.metricsCtx.setMetricsListener(null);
        try {
            ServiceUtil.MBEAN_SERVER.unregisterMBean(this.objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            // empty catch block
        }
    }

    @Override
    public final void notify(MetricsContext.Snapshot snapshot) {
        this.startTimeMillis = snapshot.getStartTimeMillis();
        this.succCount = snapshot.getSuccCount();
        this.succRateMean = snapshot.getSuccRateMean();
        this.succRateLast = snapshot.getSuccRateLast();
        this.failCount = snapshot.getFailCount();
        this.failRateMean = snapshot.getFailRateMean();
        this.failRateLast = snapshot.getFailRateLast();
        this.byteCount = snapshot.getByteCount();
        this.byteRateMean = snapshot.getByteRateMean();
        this.byteRateLast = snapshot.getByteRateLast();
        this.elapsedTimeMillis = snapshot.getElapsedTimeMillis();
        this.actualConcurrencyLast = snapshot.getActualConcurrencyLast();
        this.actualConcurrencyMean = snapshot.getActualConcurrencyMean();
        this.durationSum = snapshot.getDurationSum();
        this.latencySum = snapshot.getLatencySum();
        this.durationMin = snapshot.getDurationMin();
        this.durationLoQ = snapshot.getDurationLoQ();
        this.durationMed = snapshot.getDurationMed();
        this.durationHiQ = snapshot.getDurationHiQ();
        this.durationMax = snapshot.getDurationMax();
        this.latencyMin = snapshot.getLatencyMin();
        this.latencyLoQ = snapshot.getLatencyLoQ();
        this.latencyMed = snapshot.getLatencyMed();
        this.latencyHiQ = snapshot.getLatencyHiQ();
        this.latencyMax = snapshot.getLatencyMax();
        this.durationMean = snapshot.getDurationMean();
        this.latencyMean = snapshot.getLatencyMean();
    }

    @Override
    public final long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public final long getSuccCount() {
        return this.succCount;
    }

    @Override
    public final double getSuccRateMean() {
        return this.succRateMean;
    }

    @Override
    public final double getSuccRateLast() {
        return this.succRateLast;
    }

    @Override
    public final long getFailCount() {
        return this.failCount;
    }

    @Override
    public final double getFailRateMean() {
        return this.failRateMean;
    }

    @Override
    public final double getFailRateLast() {
        return this.failRateLast;
    }

    @Override
    public final long getByteCount() {
        return this.byteCount;
    }

    @Override
    public final double getByteRateMean() {
        return this.byteRateMean;
    }

    @Override
    public final double getByteRateLast() {
        return this.byteRateLast;
    }

    @Override
    public final long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @Override
    public final int getActualConcurrencyLast() {
        return this.actualConcurrencyLast;
    }

    @Override
    public final double getActualConcurrencyMean() {
        return this.actualConcurrencyMean;
    }

    @Override
    public final long getDurationSum() {
        return this.durationSum;
    }

    @Override
    public final long getLatencySum() {
        return this.latencySum;
    }

    @Override
    public final long getDurationMin() {
        return this.durationMin;
    }

    @Override
    public final long getDurationLoQ() {
        return this.durationLoQ;
    }

    @Override
    public final long getDurationMed() {
        return this.durationMed;
    }

    @Override
    public final long getDurationHiQ() {
        return this.durationHiQ;
    }

    @Override
    public final long getDurationMax() {
        return this.durationMax;
    }

    @Override
    public final double getDurationMean() {
        return this.durationMean;
    }

    @Override
    public final long getLatencyMin() {
        return this.latencyMin;
    }

    @Override
    public final long getLatencyLoQ() {
        return this.latencyLoQ;
    }

    @Override
    public final long getLatencyMed() {
        return this.latencyMed;
    }

    @Override
    public final long getLatencyHiQ() {
        return this.latencyHiQ;
    }

    @Override
    public final long getLatencyMax() {
        return this.latencyMax;
    }

    @Override
    public final double getLatencyMean() {
        return this.latencyMean;
    }
}

