/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.emc.mongoose.api.metrics.MetricsListener;
import com.emc.mongoose.api.model.io.IoType;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.Closeable;
import java.io.Serializable;

public interface MetricsContext
extends Closeable {
    public static final int DEFAULT_RESERVOIR_SIZE = 1000;
    public static final int DEFAULT_DISTRIBUTION_SNAPSHOT_UPDATE_PERIOD_MILLIS = 10;

    public void start();

    public boolean isStarted();

    public void markSucc(long var1, long var3, long var5);

    public void markPartSucc(long var1, long var3, long var5);

    public void markSucc(long var1, long var3, long[] var5, long[] var6);

    public void markPartSucc(long var1, long[] var3, long[] var4);

    public void markFail();

    public void markFail(long var1);

    public void markElapsedTime(long var1);

    public String getStepId();

    public IoType getIoType();

    public int getDriverCount();

    public int getConcurrency();

    public int getConcurrencyThreshold();

    public int getActualConcurrency();

    public SizeInBytes getItemDataSize();

    public boolean getStdOutColorFlag();

    public boolean getAvgPersistFlag();

    public boolean getSumPersistFlag();

    public boolean getPerfDbResultsFileFlag();

    public long getOutputPeriodMillis();

    public long getLastOutputTs();

    public void setLastOutputTs(long var1);

    public void refreshLastSnapshot();

    public Snapshot getLastSnapshot();

    public void setMetricsListener(MetricsListener var1);

    public boolean isThresholdStateEntered();

    public void enterThresholdState() throws IllegalStateException;

    public boolean isThresholdStateExited();

    public MetricsContext getThresholdMetrics();

    public void exitThresholdState() throws IllegalStateException;

    public static interface Snapshot
    extends Serializable {
        public long getStartTimeMillis();

        public long getSuccCount();

        public double getSuccRateMean();

        public double getSuccRateLast();

        public long getFailCount();

        public double getFailRateMean();

        public double getFailRateLast();

        public long getByteCount();

        public double getByteRateMean();

        public double getByteRateLast();

        public long getElapsedTimeMillis();

        public int getActualConcurrencyLast();

        public double getActualConcurrencyMean();

        public long getDurationSum();

        public long getLatencySum();

        public long getDurationMin();

        public long getDurationLoQ();

        public long getDurationMed();

        public long getDurationHiQ();

        public long getDurationMax();

        public double getDurationMean();

        public long getLatencyMin();

        public long getLatencyLoQ();

        public long getLatencyMed();

        public long getLatencyHiQ();

        public long getLatencyMax();

        public double getLatencyMean();
    }
}

