/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.emc.mongoose.api.metrics.Meter;
import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.metrics.logging.BasicMetricsLogMessage;
import com.emc.mongoose.api.metrics.logging.ExtResultsXmlLogMessage;
import com.emc.mongoose.api.metrics.logging.MetricsAsciiTableLogMessage;
import com.emc.mongoose.api.metrics.logging.MetricsCsvLogMessage;
import com.emc.mongoose.api.model.concurrent.DaemonBase;
import com.emc.mongoose.api.model.concurrent.ThreadDump;
import com.emc.mongoose.api.model.load.LoadController;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.coroutines.Coroutine;
import java.io.Closeable;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MalformedObjectNameException;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;

public final class MetricsManager
extends DaemonBase
implements Coroutine {
    private final Map<LoadController, Map<MetricsContext, Closeable>> allMetrics = new HashMap<LoadController, Map<MetricsContext, Closeable>>();
    private final Set<MetricsContext> selectedMetrics = new TreeSet<MetricsContext>();
    private final Lock allMetricsLock = new ReentrantLock();
    private long outputPeriodMillis;
    private long lastOutputTs;
    private long nextOutputTs;
    private static final String CLS_NAME = MetricsManager.class.getSimpleName();
    private static final MetricsManager INSTANCE;

    private MetricsManager() {
        SVC_EXECUTOR.start((Coroutine)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(LoadController controller, MetricsContext metricsCtx) throws InterruptedException {
        if (MetricsManager.INSTANCE.allMetricsLock.tryLock(1L, TimeUnit.SECONDS)) {
            try (CloseableThreadContext.Instance stepIdCtx = CloseableThreadContext.put((String)"stepId", (String)metricsCtx.getStepId());){
                Map controllerMetrics = MetricsManager.INSTANCE.allMetrics.computeIfAbsent(controller, c -> new HashMap());
                controllerMetrics.put(metricsCtx, new Meter(metricsCtx));
                Loggers.MSG.info("Metrics context \"{}\" registered", (Object)metricsCtx);
            }
            catch (MalformedObjectNameException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to register the MBean for the metrics context \"{}\"", (Object[])new Object[]{metricsCtx.toString()});
            }
            finally {
                MetricsManager.INSTANCE.allMetricsLock.unlock();
            }
        } else {
            Loggers.ERR.warn("Locking timeout at register call, thread dump:\n{}", (Object)new ThreadDump().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unregister(LoadController controller, MetricsContext metricsCtx) throws InterruptedException {
        if (MetricsManager.INSTANCE.allMetricsLock.tryLock(1L, TimeUnit.SECONDS)) {
            try (CloseableThreadContext.Instance stepIdCtx = CloseableThreadContext.put((String)"stepId", (String)metricsCtx.getStepId());){
                Map<MetricsContext, Closeable> controllerMetrics = MetricsManager.INSTANCE.allMetrics.get(controller);
                if (controllerMetrics != null) {
                    metricsCtx.refreshLastSnapshot();
                    if (metricsCtx.isThresholdStateEntered() && !metricsCtx.isThresholdStateExited()) {
                        MetricsManager.exitMetricsThresholdState(metricsCtx);
                    }
                    if (metricsCtx.getSumPersistFlag()) {
                        Loggers.METRICS_FILE_TOTAL.info((Message)new MetricsCsvLogMessage(metricsCtx));
                    }
                    if (metricsCtx.getPerfDbResultsFileFlag()) {
                        Loggers.METRICS_EXT_RESULTS_FILE.info((Message)new ExtResultsXmlLogMessage(metricsCtx));
                    }
                    Loggers.METRICS_STD_OUT.info((Message)new BasicMetricsLogMessage(metricsCtx));
                    Closeable meterMBean = controllerMetrics.remove(metricsCtx);
                    if (meterMBean != null) {
                        try {
                            meterMBean.close();
                        }
                        catch (IOException e) {
                            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to close the meter MBean", (Object[])new Object[0]);
                        }
                    }
                } else {
                    Loggers.ERR.debug("Metrics context \"{}\" has not been registered", (Object)metricsCtx);
                }
                if (controllerMetrics == null || controllerMetrics.size() != 0) return;
                MetricsManager.INSTANCE.allMetrics.remove(controller);
                return;
            }
            finally {
                MetricsManager.INSTANCE.allMetricsLock.unlock();
                Loggers.MSG.info("Metrics context \"{}\" unregistered", (Object)metricsCtx);
            }
        } else {
            Loggers.ERR.warn("Locking timeout at unregister call, thread dump:\n{}", (Object)new ThreadDump().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.allMetricsLock.tryLock()) {
            try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"className", (String)CLS_NAME);){
                for (LoadController controller : this.allMetrics.keySet()) {
                    if (controller.isInterrupted() || controller.isClosed()) continue;
                    for (MetricsContext metricsCtx : this.allMetrics.get(controller).keySet()) {
                        CloseableThreadContext.Instance stepIdCtx = CloseableThreadContext.put((String)"stepId", (String)metricsCtx.getStepId());
                        Throwable throwable = null;
                        try {
                            int actualConcurrency = metricsCtx.getActualConcurrency();
                            metricsCtx.refreshLastSnapshot();
                            int nextConcurrencyThreshold = metricsCtx.getConcurrencyThreshold();
                            if (nextConcurrencyThreshold > 0 && actualConcurrency >= nextConcurrencyThreshold) {
                                if (!metricsCtx.isThresholdStateEntered() && !metricsCtx.isThresholdStateExited()) {
                                    Loggers.MSG.info("{}: the threshold of {} active tasks count is reached, starting the additional metrics accounting", (Object)metricsCtx.toString(), (Object)metricsCtx.getConcurrencyThreshold());
                                    metricsCtx.enterThresholdState();
                                }
                            } else if (metricsCtx.isThresholdStateEntered() && !metricsCtx.isThresholdStateExited()) {
                                MetricsManager.exitMetricsThresholdState(metricsCtx);
                            }
                            this.outputPeriodMillis = metricsCtx.getOutputPeriodMillis();
                            this.lastOutputTs = metricsCtx.getLastOutputTs();
                            this.nextOutputTs = System.currentTimeMillis();
                            if (this.outputPeriodMillis <= 0L || this.nextOutputTs - this.lastOutputTs < this.outputPeriodMillis || controller.isInterrupted() || controller.isClosed()) continue;
                            this.selectedMetrics.add(metricsCtx);
                            metricsCtx.setLastOutputTs(this.nextOutputTs);
                            if (!metricsCtx.getAvgPersistFlag()) continue;
                            Loggers.METRICS_FILE.info((Message)new MetricsCsvLogMessage(metricsCtx));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stepIdCtx == null) continue;
                            if (throwable != null) {
                                try {
                                    stepIdCtx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stepIdCtx.close();
                        }
                    }
                }
                if (!this.selectedMetrics.isEmpty()) {
                    Loggers.METRICS_STD_OUT.info((Message)new MetricsAsciiTableLogMessage(this.selectedMetrics));
                    this.selectedMetrics.clear();
                }
            }
            catch (Throwable cause) {
                LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Metrics manager failure", (Object[])new Object[0]);
            }
            finally {
                this.allMetricsLock.unlock();
            }
        }
    }

    private static void exitMetricsThresholdState(MetricsContext metricsCtx) {
        Loggers.MSG.info("{}: the active tasks count is below the threshold of {}, stopping the additional metrics accounting", (Object)metricsCtx.toString(), (Object)metricsCtx.getConcurrencyThreshold());
        MetricsContext lastThresholdMetrics = metricsCtx.getThresholdMetrics();
        if (lastThresholdMetrics.getSumPersistFlag()) {
            Loggers.METRICS_THRESHOLD_FILE_TOTAL.info((Message)new MetricsCsvLogMessage(lastThresholdMetrics));
        }
        if (lastThresholdMetrics.getPerfDbResultsFileFlag()) {
            Loggers.METRICS_THRESHOLD_EXT_RESULTS_FILE.info((Message)new ExtResultsXmlLogMessage(lastThresholdMetrics));
        }
        metricsCtx.exitThresholdState();
    }

    public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException, RemoteException {
        if (this.isStarted() || this.isShutdown()) {
            this.state.wait(timeUnit.toMillis(timeout));
        }
        return !this.isStarted() && !this.isShutdown();
    }

    protected final void doStart() {
    }

    protected final void doShutdown() {
    }

    protected final void doInterrupt() {
        SVC_EXECUTOR.stop((Coroutine)this);
    }

    protected final void doClose() {
        block7: {
            try {
                if (this.allMetricsLock.tryLock(1L, TimeUnit.SECONDS)) {
                    try {
                        for (LoadController controller : this.allMetrics.keySet()) {
                            this.allMetrics.get(controller).clear();
                        }
                        this.allMetrics.clear();
                        break block7;
                    }
                    finally {
                        this.allMetricsLock.unlock();
                    }
                }
                Loggers.ERR.warn("Locking timeout at closing, thread dump:\n{}", (Object)new ThreadDump().toString());
            }
            catch (InterruptedException e) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Got interrupted exception", (Object[])new Object[0]);
            }
        }
    }

    public void stop() {
        this.interrupt();
    }

    public boolean isStopped() {
        return this.isInterrupted();
    }

    static {
        try {
            INSTANCE = new MetricsManager();
            INSTANCE.start();
        }
        catch (Throwable cause) {
            throw new AssertionError((Object)cause);
        }
    }
}

