/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformSnapshot;
import com.github.akurilov.commons.math.Random;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class UnsafeButFasterUniformReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private static final int BITS_PER_LONG = 63;
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLongArray values;
    private static final Random RND = new Random();

    public UnsafeButFasterUniformReservoir() {
        this(1028);
    }

    public UnsafeButFasterUniformReservoir(int size) {
        this.values = new AtomicLongArray(size);
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.count.set(0L);
    }

    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    public void update(long value) {
        long c = this.count.incrementAndGet();
        if (c <= (long)this.values.length()) {
            this.values.set((int)c - 1, value);
        } else {
            long r = UnsafeButFasterUniformReservoir.nextLong(c);
            if (r < (long)this.values.length()) {
                this.values.set((int)r, value);
            }
        }
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = RND.nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public Snapshot getSnapshot() {
        int s = this.size();
        ArrayList<Long> copy = new ArrayList<Long>(s);
        for (int i = 0; i < s; ++i) {
            copy.add(this.values.get(i));
        }
        return new UniformSnapshot(copy);
    }
}

