/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics.logging;

import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.ui.log.LogMessageBase;
import com.emc.mongoose.ui.log.LogUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;

@AsynchronouslyFormattable
public final class BasicMetricsLogMessage
extends LogMessageBase {
    private MetricsContext metricsCtx;

    public BasicMetricsLogMessage(MetricsContext metricsCtx) {
        this.metricsCtx = metricsCtx;
    }

    public final void formatTo(StringBuilder buffer) {
        MetricsContext.Snapshot snapshot = this.metricsCtx.getLastSnapshot();
        long succCount = snapshot.getSuccCount();
        long failCount = snapshot.getFailCount();
        IoType ioType = this.metricsCtx.getIoType();
        boolean stdOutColorFlag = this.metricsCtx.getStdOutColorFlag();
        String ioTypeColorCode = "\u001b[37;1m";
        switch (ioType) {
            case NOOP: {
                ioTypeColorCode = "\u001b[38;5;101m";
                break;
            }
            case CREATE: {
                ioTypeColorCode = "\u001b[38;5;67m";
                break;
            }
            case READ: {
                ioTypeColorCode = "\u001b[38;5;65m";
                break;
            }
            case UPDATE: {
                ioTypeColorCode = "\u001b[38;5;104m";
                break;
            }
            case DELETE: {
                ioTypeColorCode = "\u001b[38;5;137m";
                break;
            }
            case LIST: {
                ioTypeColorCode = "\u001b[38;5;138m";
            }
        }
        buffer.append("Step \"").append(this.metricsCtx.getStepId()).append("\" results:\n\t");
        if (stdOutColorFlag) {
            buffer.append(ioTypeColorCode);
        }
        buffer.append(this.metricsCtx.getIoType().name());
        if (stdOutColorFlag) {
            buffer.append("\u001b[0m");
        }
        buffer.append('-').append(this.metricsCtx.getConcurrency()).append('x').append(this.metricsCtx.getDriverCount()).append(": c=(").append(BasicMetricsLogMessage.formatFixedWidth((double)snapshot.getActualConcurrencyMean(), (int)6)).append("); n=(");
        if (stdOutColorFlag) {
            buffer.append("\u001b[37;1m");
        }
        buffer.append(succCount);
        if (stdOutColorFlag) {
            buffer.append("\u001b[0m");
        }
        buffer.append('/');
        if (stdOutColorFlag) {
            buffer.append(LogUtil.getFailureRatioAnsiColorCode((long)succCount, (long)failCount));
        }
        buffer.append(failCount);
        if (stdOutColorFlag) {
            buffer.append("\u001b[0m");
        }
        buffer.append("); t[s]=(").append(BasicMetricsLogMessage.formatFixedWidth((double)((double)snapshot.getElapsedTimeMillis() / 1000.0), (int)7)).append('/').append(BasicMetricsLogMessage.formatFixedWidth((double)((double)snapshot.getDurationSum() / 1000000.0), (int)7)).append("); size=(").append(SizeInBytes.formatFixedSize((long)snapshot.getByteCount())).append("); TP[op/s]=(").append(BasicMetricsLogMessage.formatFixedWidth((double)snapshot.getSuccRateMean(), (int)7)).append('/').append(BasicMetricsLogMessage.formatFixedWidth((double)snapshot.getSuccRateLast(), (int)7)).append("); BW[MB/s]=(").append(BasicMetricsLogMessage.formatFixedWidth((double)(snapshot.getByteRateMean() / 1048576.0), (int)6)).append('/').append(BasicMetricsLogMessage.formatFixedWidth((double)(snapshot.getByteRateLast() / 1048576.0), (int)6)).append("); dur[us]=(").append((long)snapshot.getDurationMean()).append('/').append(snapshot.getDurationMin()).append('/').append(snapshot.getDurationMax()).append("); lat[us]=(").append((long)snapshot.getLatencyMean()).append('/').append(snapshot.getLatencyMin()).append('/').append(snapshot.getLatencyMax()).append(')').append(System.lineSeparator());
    }
}

