/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics.logging;

import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.ui.log.LogMessageBase;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;

@AsynchronouslyFormattable
public final class ExtResultsXmlLogMessage
extends LogMessageBase {
    private static final DateFormat FMT_DATE_RESULTS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private final MetricsContext metricsCtx;

    public ExtResultsXmlLogMessage(MetricsContext metricsCtx) {
        this.metricsCtx = metricsCtx;
    }

    public final void formatTo(StringBuilder buffer) {
        buffer.append("<result id=\"").append(this.metricsCtx.getStepId()).append("\" ");
        MetricsContext.Snapshot snapshot = this.metricsCtx.getLastSnapshot();
        long startTimeMillis = snapshot.getStartTimeMillis();
        Date startDate = new Date(startTimeMillis);
        buffer.append("StartDate=\"").append(FMT_DATE_RESULTS.format(startDate)).append("\" ");
        buffer.append("StartTimestamp=\"").append(startTimeMillis).append("\" ");
        long elapsedTimeMillis = snapshot.getElapsedTimeMillis();
        long endTimeStamp = startTimeMillis + elapsedTimeMillis;
        Date endDate = new Date(endTimeStamp);
        buffer.append("EndDate=\"").append(FMT_DATE_RESULTS.format(endDate)).append("\" ");
        buffer.append("EndTimestamp=\"").append(endTimeStamp).append("\" ");
        int ioTypeCode = this.metricsCtx.getIoType().ordinal();
        buffer.append("operation=\"").append(IoType.values()[ioTypeCode].name()).append("\" ");
        int concurrency = this.metricsCtx.getConcurrency();
        int driversCount = this.metricsCtx.getDriverCount();
        buffer.append("threads=\"").append(concurrency * driversCount).append("\" ");
        buffer.append("RequestThreads=\"").append(concurrency).append("\" ");
        buffer.append("clients=\"").append(driversCount).append("\" ");
        buffer.append("error=\"").append(snapshot.getFailCount()).append("\" ");
        buffer.append("runtime=\"").append((float)elapsedTimeMillis / 1000.0f).append("\" ");
        String itemDataSizeStr = this.metricsCtx.getItemDataSize().toString();
        buffer.append("filesize=\"").append(itemDataSizeStr).append("\" ");
        buffer.append("tps=\"").append(snapshot.getSuccRateMean()).append("\" tps_unit=\"Fileps\" ");
        buffer.append("bw=\"").append(snapshot.getByteRateMean() / 1048576.0).append("\" bw_unit=\"MBps\" ");
        buffer.append("latency=\"").append(snapshot.getLatencyMean()).append("\" latency_unit=\"us\" ");
        buffer.append("latency_min=\"").append(snapshot.getLatencyMin()).append("\" ");
        buffer.append("latency_loq=\"").append(snapshot.getLatencyLoQ()).append("\" ");
        buffer.append("latency_med=\"").append(snapshot.getLatencyMed()).append("\" ");
        buffer.append("latency_hiq=\"").append(snapshot.getLatencyHiQ()).append("\" ");
        buffer.append("latency_max=\"").append(snapshot.getLatencyMax()).append("\" ");
        buffer.append("duration=\"").append(snapshot.getDurationMean()).append("\" duration_unit=\"us\" ");
        buffer.append("duration_min=\"").append(snapshot.getDurationMin()).append("\" ");
        buffer.append("duration_loq=\"").append(snapshot.getDurationLoQ()).append("\" ");
        buffer.append("duration_med=\"").append(snapshot.getDurationMed()).append("\" ");
        buffer.append("duration_hiq=\"").append(snapshot.getDurationHiQ()).append("\" ");
        buffer.append("duration_max=\"").append(snapshot.getDurationMax()).append("\" ");
        buffer.append("/>\n");
    }
}

