/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics.logging;

import com.emc.mongoose.api.metrics.logging.IoTraceRecord;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.ui.log.LogMessageBase;
import com.emc.mongoose.ui.log.Loggers;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;

@AsynchronouslyFormattable
public final class IoTraceCsvBatchLogMessage<I extends Item, O extends IoTask<I>>
extends LogMessageBase {
    private final List<IoTraceRecord<I, O>> ioTraceRecords;
    private final int size;

    public IoTraceCsvBatchLogMessage(List<O> ioTaskResults, int from, int to) {
        this.size = to - from;
        if (this.size > 100000) {
            Loggers.ERR.warn("I/O trace batch size too big: {}", (Object)(to - from));
        }
        this.ioTraceRecords = new ArrayList<IoTraceRecord<I, O>>(this.size);
        for (int i = from; i < to; ++i) {
            this.ioTraceRecords.add(new IoTraceRecord((IoTask)ioTaskResults.get(i)));
        }
    }

    public final void formatTo(StringBuilder strb) {
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                this.ioTraceRecords.get(i).format(strb);
            }
        }
    }
}

