/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics.logging;

import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.Item;

public final class IoTraceRecord<I extends Item, O extends IoTask<I>> {
    protected final String storageNode;
    protected final String itemPath;
    protected final int ioTypeCode;
    protected final int statusCode;
    protected final long reqTimeStart;
    protected final long duration;
    protected final long respLatency;
    protected final long dataLatency;
    protected final long transferSize;

    public IoTraceRecord(O ioTaskResult) {
        int commaPos;
        this.storageNode = ioTaskResult.getNodeAddr();
        String itemInfo = ioTaskResult.getItem().toString();
        this.itemPath = itemInfo != null ? ((commaPos = itemInfo.indexOf(44, 0)) > 0 ? itemInfo.substring(0, itemInfo.indexOf(44, 0)) : itemInfo) : null;
        this.ioTypeCode = ioTaskResult.getIoType().ordinal();
        this.statusCode = ioTaskResult.getStatus().ordinal();
        this.reqTimeStart = ioTaskResult.getReqTimeStart();
        this.duration = ioTaskResult.getRespTimeDone() - this.reqTimeStart;
        long t = ioTaskResult.getRespTimeStart() - ioTaskResult.getReqTimeDone();
        long l = this.respLatency = t < this.duration && t > 0L ? t : -1L;
        if (ioTaskResult instanceof DataIoTask) {
            DataIoTask dataIoResult = (DataIoTask)ioTaskResult;
            t = ioTaskResult.getReqTimeDone() - dataIoResult.getRespDataTimeStart();
            this.dataLatency = t < this.duration && t > 0L ? t : -1L;
            this.transferSize = dataIoResult.getCountBytesDone();
        } else {
            this.dataLatency = -1L;
            this.transferSize = -1L;
        }
    }

    public final void format(StringBuilder strb) {
        if (this.storageNode != null) {
            strb.append(this.storageNode);
        }
        strb.append(',');
        if (this.itemPath != null) {
            strb.append(this.itemPath);
        }
        strb.append(',');
        if (this.ioTypeCode != -1) {
            strb.append(this.ioTypeCode);
        }
        strb.append(',');
        if (this.statusCode != -1) {
            strb.append(this.statusCode);
        }
        strb.append(',');
        if (this.reqTimeStart > 0L) {
            strb.append(this.reqTimeStart);
        }
        strb.append(',');
        if (this.duration > 0L) {
            strb.append(this.duration);
        }
        strb.append(',');
        if (this.respLatency > 0L) {
            strb.append(this.respLatency);
        }
        strb.append(',');
        if (this.dataLatency > 0L) {
            strb.append(this.dataLatency);
        }
        strb.append(',');
        if (this.transferSize != -1L) {
            strb.append(this.transferSize);
        }
        strb.append('\n');
    }
}

