/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.metrics.logging;

import com.emc.mongoose.api.common.env.DateUtil;
import com.emc.mongoose.api.metrics.MetricsContext;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.ui.log.LogMessageBase;
import com.emc.mongoose.ui.log.LogUtil;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrBuilder;

public class MetricsAsciiTableLogMessage
extends LogMessageBase {
    public static final String TABLE_HEADER = "------------------------------------------------------------------------------------------------------------------------" + SystemUtils.LINE_SEPARATOR + " Step Id  | Timestamp  |  Op  |     Concurrency     |       Count       | Step  |   Last Rate    |  Mean    |   Mean    " + SystemUtils.LINE_SEPARATOR + " (last 10 |            | type |---------------------|-------------------| Time  |----------------| Latency  | Duration  " + SystemUtils.LINE_SEPARATOR + " symbols) |yyMMddHHmmss|      | Current  |   Mean   |   Success  |Failed|  [s]  | [op/s] |[MB/s] |  [us]    |   [us]    " + SystemUtils.LINE_SEPARATOR + "----------|------------|------|----------|----------|------------|------|-------|--------|-------|----------|-----------" + SystemUtils.LINE_SEPARATOR;
    public static final String TABLE_BORDER_VERTICAL = "|";
    public static final int TABLE_HEADER_PERIOD = 20;
    private static volatile long ROW_OUTPUT_COUNTER = 0L;
    private final Set<MetricsContext> metrics;
    private volatile String formattedMsg = null;

    public MetricsAsciiTableLogMessage(Set<MetricsContext> metrics) {
        this.metrics = metrics;
    }

    public final void formatTo(StringBuilder buffer) {
        if (this.formattedMsg == null) {
            StrBuilder strb = new StrBuilder();
            for (MetricsContext metricsCtx : this.metrics) {
                MetricsContext.Snapshot snapshot = metricsCtx.getLastSnapshot();
                long succCount = snapshot.getSuccCount();
                long failCount = snapshot.getFailCount();
                IoType ioType = metricsCtx.getIoType();
                boolean stdOutColorFlag = metricsCtx.getStdOutColorFlag();
                if (0L == ROW_OUTPUT_COUNTER % 20L) {
                    strb.append(TABLE_HEADER);
                }
                ++ROW_OUTPUT_COUNTER;
                strb.appendFixedWidthPadLeft((Object)metricsCtx.getStepId(), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((Object)DateUtil.FMT_DATE_METRICS_TABLE.format(new Date()), 12, ' ').append(TABLE_BORDER_VERTICAL);
                if (stdOutColorFlag) {
                    switch (ioType) {
                        case NOOP: {
                            strb.append("\u001b[38;5;101m");
                            break;
                        }
                        case CREATE: {
                            strb.append("\u001b[38;5;67m");
                            break;
                        }
                        case READ: {
                            strb.append("\u001b[38;5;65m");
                            break;
                        }
                        case UPDATE: {
                            strb.append("\u001b[38;5;104m");
                            break;
                        }
                        case DELETE: {
                            strb.append("\u001b[38;5;137m");
                            break;
                        }
                        case LIST: {
                            strb.append("\u001b[38;5;138m");
                        }
                    }
                }
                strb.appendFixedWidthPadRight((Object)metricsCtx.getIoType().name(), 6, ' ');
                if (stdOutColorFlag) {
                    strb.append("\u001b[0m");
                }
                strb.append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft(snapshot.getActualConcurrencyLast(), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight((Object)MetricsAsciiTableLogMessage.formatFixedWidth((double)snapshot.getActualConcurrencyMean(), (int)6), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((Object)succCount, 12, ' ').append(TABLE_BORDER_VERTICAL);
                if (stdOutColorFlag) {
                    strb.append(LogUtil.getFailureRatioAnsiColorCode((long)succCount, (long)failCount));
                }
                strb.appendFixedWidthPadLeft((Object)failCount, 6, ' ');
                if (stdOutColorFlag) {
                    strb.append("\u001b[0m");
                }
                strb.append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight((Object)((double)snapshot.getElapsedTimeMillis() / 1000.0), 7, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight((Object)snapshot.getSuccRateLast(), 8, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadRight((Object)(snapshot.getByteRateLast() / 1048576.0), 7, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((Object)((long)snapshot.getLatencyMean()), 10, ' ').append(TABLE_BORDER_VERTICAL).appendFixedWidthPadLeft((Object)((long)snapshot.getDurationMean()), 11, ' ').appendNewLine();
            }
            this.formattedMsg = strb.toString();
        }
        buffer.append(this.formattedMsg);
    }
}

