/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config;

import com.emc.mongoose.base.logging.Loggers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface AliasingUtil {
    public static final String NAME = "name";
    public static final String TARGET = "target";
    public static final String DEPRECATED = "deprecated";
    public static final String ARG_VAL_SEP = "=";

    public static Map<String, String> apply(Map<String, String> args, List<Map<String, Object>> aliasingConfig) throws IllegalArgumentException {
        HashMap<String, String> newArgs = new HashMap<String, String>();
        Iterator<String> iterator = args.keySet().iterator();
        while (iterator.hasNext()) {
            String argName;
            String newArgName = argName = iterator.next();
            String newArgValue = args.get(argName);
            for (Map<String, Object> aliasingEntry : aliasingConfig) {
                boolean deprecationFlag;
                String aliasName = (String)aliasingEntry.get(NAME);
                String aliasTarget = (String)aliasingEntry.get(TARGET);
                boolean bl = deprecationFlag = aliasingEntry.containsKey(DEPRECATED) && (Boolean)aliasingEntry.get(DEPRECATED) != false;
                if (!argName.equals(aliasName)) continue;
                if (aliasTarget == null) {
                    throw new IllegalArgumentException("The argument \"" + aliasName + "\" is deprecated");
                }
                if (deprecationFlag) {
                    Loggers.ERR.warn("The argument \"" + aliasName + "\" is deprecated, use \"" + aliasTarget + "\" instead");
                }
                String[] aliasArgValPair = aliasTarget.split(ARG_VAL_SEP, 2);
                newArgName = aliasArgValPair[0];
                if (aliasArgValPair.length != 2) break;
                newArgValue = aliasArgValPair[1];
                break;
            }
            newArgs.put(newArgName, newArgValue);
        }
        return newArgs;
    }
}

