/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config;

import com.emc.mongoose.base.config.IllegalArgumentNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface CliArgUtil {
    public static final String ARG_PREFIX = "--";
    public static final String ARG_PATH_SEP = "-";
    public static final String ARG_VAL_SEP = "=";

    public static Map<String, String> parseArgs(String ... args) {
        return Arrays.stream(args).peek(arg -> {
            if (!arg.startsWith(ARG_PREFIX)) {
                throw new IllegalArgumentNameException((String)arg);
            }
        }).map(arg -> arg.substring(ARG_PREFIX.length())).map(arg -> arg.split(ARG_VAL_SEP, 2)).map(argValPair -> {
            String[] stringArray;
            if (((String[])argValPair).length == 2) {
                stringArray = argValPair;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = argValPair[0];
                stringArray = stringArray2;
                stringArray2[1] = Boolean.TRUE.toString();
            }
            return stringArray;
        }).collect(Collectors.toMap(argValPair -> argValPair[0], argValPair -> argValPair[1]));
    }

    public static List<String> allCliArgs(Map<String, Object> schema, String sep) {
        ArrayList<String> allArgs = new ArrayList<String>();
        schema.entrySet().stream().map(schemaEntry -> CliArgUtil.argsFromSchemaEntry(ARG_PREFIX, sep, schemaEntry)).forEach(allArgs::addAll);
        return allArgs;
    }

    public static List<String> argsFromSchemaEntry(String prefix, String sep, Map.Entry<String, Object> schemaEntry) {
        ArrayList<String> args = new ArrayList<String>();
        String schemaKey = schemaEntry.getKey();
        Object schemaVal = schemaEntry.getValue();
        if (schemaVal instanceof Map) {
            ((Map)schemaVal).entrySet().stream().map(e -> CliArgUtil.argsFromSchemaEntry(prefix + schemaKey + sep, sep, e)).forEach(args::addAll);
        } else {
            args.add(prefix + schemaKey + "=<" + schemaVal + ">");
        }
        return args;
    }
}

