/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.config.el;

import com.emc.mongoose.base.config.el.AsyncExpressionInputImpl;
import com.emc.mongoose.base.config.el.CompositeExpressionInputBuilder;
import com.emc.mongoose.base.config.el.Language;
import com.github.akurilov.commons.io.collection.CompositeStringInput;
import com.github.akurilov.commons.io.el.ExpressionInput;
import com.github.akurilov.commons.io.el.SynchronousExpressionInput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompositeExpressionInputBuilderImpl
implements CompositeExpressionInputBuilder {
    static final Pattern INITIAL_VALUE_PATTERN;
    static final Formatter FORMATTER;
    private final ExpressionInput.Builder inputBuilder = ExpressionInput.builder();
    private volatile String expr;

    public CompositeExpressionInputBuilderImpl() {
        Language.withLanguage(this.inputBuilder);
    }

    @Override
    public final <T extends CompositeExpressionInputBuilder> T expression(String expr) {
        this.expr = expr;
        return (T)this;
    }

    @Override
    public final <T extends CompositeExpressionInputBuilder> T function(String prefix, String name, Method method) {
        this.inputBuilder.function(prefix, name, method);
        return (T)this;
    }

    @Override
    public final <T extends CompositeExpressionInputBuilder> T value(String name, Object value, Class<?> type) {
        this.inputBuilder.value(name, value, type);
        return (T)this;
    }

    @Override
    public final CompositeStringInput build() {
        ArrayList<Object> segments = new ArrayList<Object>();
        Matcher matcher = ExpressionInput.EXPRESSION_PATTERN.matcher(this.expr);
        StringBuilder constSegmentBuilder = new StringBuilder();
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            end = matcher.start();
            if (end > 0) {
                constSegmentBuilder.append(this.expr, start, end);
            }
            start = matcher.end();
            String fullSegmentExpr = matcher.group(0);
            String segmentExpr = matcher.group(1);
            String segmentInit = matcher.group(2);
            if (segmentExpr == null && segmentInit == null) continue;
            String constSegment = constSegmentBuilder.toString();
            if (!constSegment.isEmpty()) {
                segments.add(constSegment);
                constSegmentBuilder.setLength(0);
            }
            Object inputSegment = this.inputBuilder.expression(fullSegmentExpr).build();
            if (null == segmentExpr || inputSegment instanceof SynchronousExpressionInput) {
                segments.add(inputSegment);
                continue;
            }
            AsyncExpressionInputImpl asyncInputSegment = new AsyncExpressionInputImpl(inputSegment);
            asyncInputSegment.start();
            segments.add(asyncInputSegment);
        }
        segments.add(constSegmentBuilder.toString());
        return new CompositeStringInput(segments.toArray());
    }

    static {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        INITIAL_VALUE_PATTERN = Pattern.compile(".*(%\\{.+})([$#]\\{.+}.)*");
        FORMATTER = new Formatter(Locale.ROOT);
    }
}

