/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.data;

import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.data.DataInputBase;
import com.github.akurilov.commons.math.MathUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class CachedDataInput
extends DataInputBase {
    private int layersCacheCountLimit;
    private final ThreadLocal<Int2ObjectOpenHashMap<MappedByteBuffer>> thrLocLayersCache = new ThreadLocal();

    public CachedDataInput() {
    }

    public CachedDataInput(MappedByteBuffer initialLayer, int layersCacheCountLimit) {
        super(initialLayer);
        if (layersCacheCountLimit < 1) {
            throw new IllegalArgumentException("Cache limit value should be more than 1");
        }
        this.layersCacheCountLimit = layersCacheCountLimit;
    }

    public CachedDataInput(CachedDataInput other) {
        super(other);
        this.layersCacheCountLimit = other.layersCacheCountLimit;
    }

    private long getInitialSeed() {
        return this.inputBuff.getLong(0);
    }

    @Override
    public final MappedByteBuffer getLayer(int layerIndex) throws OutOfMemoryError {
        MappedByteBuffer layer;
        if (layerIndex == 0) {
            return this.inputBuff;
        }
        Int2ObjectOpenHashMap<MappedByteBuffer> layersCache = this.thrLocLayersCache.get();
        if (layersCache == null) {
            layersCache = new Int2ObjectOpenHashMap(this.layersCacheCountLimit - 1);
            this.thrLocLayersCache.set(layersCache);
        }
        if ((layer = layersCache.get(layerIndex - 1)) == null) {
            int layersCountToFree = this.layersCacheCountLimit - layersCache.size() + 1;
            int layerSize = this.inputBuff.capacity();
            if (layersCountToFree > 0) {
                int i;
                IntIterator intIterator = layersCache.keySet().iterator();
                while (intIterator.hasNext() && ((layer = layersCache.remove(i = ((Integer)intIterator.next()).intValue())) == null || --layersCountToFree != 0)) {
                }
                layersCache.trim();
            }
            layer = (MappedByteBuffer)ByteBuffer.allocateDirect(layerSize);
            long layerSeed = Long.reverseBytes(MathUtil.xorShift(this.getInitialSeed()) << layerIndex ^ (long)layerIndex);
            DataInput.generateData(layer, layerSeed);
            layersCache.put(layerIndex - 1, layer);
        }
        return layer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        Int2ObjectMap layersCache = this.thrLocLayersCache.get();
        if (layersCache != null) {
            layersCache.clear();
            this.thrLocLayersCache.set(null);
        }
    }

    public final String toString() {
        return Long.toHexString(this.getInitialSeed()) + "," + Integer.toHexString(this.inputBuff.capacity());
    }
}

