/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.data;

import com.emc.mongoose.base.data.CachedDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class ExternalDataInput
extends CachedDataInput {
    public ExternalDataInput() {
    }

    public ExternalDataInput(ReadableByteChannel initialLayerInputChannel, int layerSize, int layersCacheCountLimit) throws IOException {
        super((MappedByteBuffer)ByteBuffer.allocateDirect(layerSize), layersCacheCountLimit);
        int doneByteCount;
        int n;
        for (doneByteCount = 0; doneByteCount < layerSize && (n = initialLayerInputChannel.read(this.inputBuff)) > 0; doneByteCount += n) {
        }
        int inputSize = doneByteCount;
        ByteBuffer initialData = this.inputBuff.asReadOnlyBuffer();
        while (doneByteCount < layerSize) {
            n = Math.min(this.inputBuff.remaining(), inputSize);
            initialData.position(0).limit(n);
            this.inputBuff.put(initialData);
            doneByteCount += n;
        }
        this.inputBuff.flip();
    }
}

