/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.env;

import com.emc.mongoose.base.Constants;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public interface DateUtil {
    public static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    public static final String PATTERN_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss,SSS";
    public static final DateFormat FMT_DATE_ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,SSS", Constants.LOCALE_DEFAULT){
        {
            this.setTimeZone(TZ_UTC);
        }
    };
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final DateFormat FMT_DATE_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Constants.LOCALE_DEFAULT){
        {
            this.setTimeZone(TZ_UTC);
        }
    };
    public static final String PATTERN_METRICS_TABLE = "yyMMddHHmmss";
    public static final DateFormat FMT_DATE_METRICS_TABLE = new SimpleDateFormat("yyMMddHHmmss", Constants.LOCALE_DEFAULT){
        {
            this.setTimeZone(TZ_UTC);
        }
    };
    public static final ThreadLocal<Map<String, DateFormat>> DATE_FORMATS = ThreadLocal.withInitial(HashMap::new);

    public static String formatNowIso8601() {
        return FMT_DATE_ISO8601.format(new Date(System.currentTimeMillis()));
    }

    public static String formatNowRfc1123() {
        return FMT_DATE_RFC1123.format(new Date(System.currentTimeMillis()));
    }

    public static DateFormat dateFormat(String pattern) {
        return DATE_FORMATS.get().computeIfAbsent(pattern, p -> {
            SimpleDateFormat f = new SimpleDateFormat((String)p, Locale.ROOT);
            f.setTimeZone(TZ_UTC);
            return f;
        });
    }

    public static Date date(long millisSinceEpoch) {
        return new Date(millisSinceEpoch);
    }

    public static long toMillisSinceEpoch(Date date) {
        return date.getTime();
    }
}

