/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.env;

import com.emc.mongoose.base.env.Installable;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public interface Extension
extends Installable {
    public static final Logger LOG = Logger.getLogger(Extension.class.getSimpleName());

    public static List<Extension> load(ClassLoader extClsLoader) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (Extension extension : ServiceLoader.load(Extension.class, extClsLoader)) {
            extensions.add(extension);
        }
        return extensions;
    }

    public static URLClassLoader extClassLoader(File dirExt) {
        URLClassLoader extClsLoader;
        if (!dirExt.exists() || !dirExt.isDirectory()) {
            LOG.warning("No \"" + dirExt.getAbsolutePath() + "\" directory, loaded no extensions");
            extClsLoader = new URLClassLoader(new URL[0]);
        } else {
            File[] extFiles = dirExt.listFiles();
            if (extFiles == null) {
                LOG.warning("Failed to load the contents of the \"" + dirExt.getAbsolutePath() + "\" directory, loaded no extensions");
                extClsLoader = new URLClassLoader(new URL[0]);
            } else {
                URL[] extFileUrls = (URL[])Arrays.stream(extFiles).filter(Extension::isJarFile).map(Extension::fileToUrl).filter(Objects::nonNull).toArray(URL[]::new);
                extClsLoader = new URLClassLoader(extFileUrls, ClassLoader.getSystemClassLoader());
            }
        }
        return extClsLoader;
    }

    public static boolean isJarFile(File f) {
        try {
            new JarFile(f);
        }
        catch (Exception e) {
            LOG.warning("Failed to load the file \"" + f + "\", expected a valid JAR/ZIP file");
            return false;
        }
        return true;
    }

    public static URL fileToUrl(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.severe(e.toString());
            return null;
        }
    }

    public String id();

    public Config defaults(Path var1);

    public SchemaProvider schemaProvider();
}

