/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.env;

import com.emc.mongoose.base.env.Installable;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.Adler32;
import org.apache.logging.log4j.Level;

public abstract class InstallableJarResources
implements Installable {
    @Override
    public void install(Path dstPath) {
        try {
            Files.createDirectories(dstPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LogUtil.trace(Loggers.ERR, Level.ERROR, e, "Failed to create directories in the path to {}", dstPath);
        }
        this.resourceFilesToInstall().forEach(resFile -> this.installResourcesFile(dstPath, (String)resFile));
        Loggers.MSG.debug("Installer finished: \"{}\"", (Object)this.getClass().getCanonicalName());
    }

    private void installResourcesFile(Path appHomePath, String srcFilePath) {
        Path dstPath = Paths.get(appHomePath.toString(), srcFilePath);
        if (dstPath.toFile().exists()) {
            int n;
            Loggers.MSG.debug("The file {} already exists, checking the checksum", (Object)dstPath);
            Adler32 checksumCalc = new Adler32();
            byte[] buff = new byte[8192];
            try (InputStream in2 = this.resourceStream(srcFilePath);){
                if (in2 == null) {
                    Loggers.ERR.warn("Resource file \"{}\" not found, skipping", (Object)srcFilePath);
                } else {
                    while (-1 < (n = in2.read(buff))) {
                        checksumCalc.update(buff, 0, n);
                    }
                }
            }
            catch (EOFException in2) {
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "Failed to read the src file \"{}\"", srcFilePath);
            }
            long srcFileChecksum = checksumCalc.getValue();
            checksumCalc.reset();
            try (InputStream in3 = Files.newInputStream(dstPath, StandardOpenOption.READ);){
                while (-1 < (n = in3.read(buff))) {
                    checksumCalc.update(buff, 0, n);
                }
            }
            catch (EOFException in3) {
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "Failed to read the dst file \"{}\"", dstPath);
            }
            long dstFileChecksum = checksumCalc.getValue();
            if (srcFileChecksum == dstFileChecksum) {
                Loggers.MSG.debug("The destination file \"{}\" has the same checksum ({}) as source, skipping", (Object)dstPath, (Object)Long.toHexString(srcFileChecksum));
                return;
            }
            Loggers.MSG.warn("The destination file \"{}\" has the different checksum ({}) than source ({}), replacing", (Object)dstPath, (Object)Long.toHexString(dstFileChecksum), (Object)Long.toHexString(srcFileChecksum));
            try {
                Files.delete(dstPath);
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "Failed to remove the outdated file \"{}\"", dstPath);
            }
        } else {
            dstPath.getParent().toFile().mkdirs();
        }
        try (InputStream srcFileInput = this.resourceStream(srcFilePath);){
            long copiedBytesCount = Files.copy(srcFileInput, dstPath, new CopyOption[0]);
            Loggers.MSG.debug("The file {} installed ({})", (Object)dstPath, (Object)copiedBytesCount);
        }
        catch (Exception e) {
            LogUtil.exception(Level.WARN, e, "Failed to copy file from {} to {}", srcFilePath, dstPath);
        }
    }

    protected InputStream resourceStream(String resPath) {
        return this.getClass().getResourceAsStream("/" + resPath);
    }

    protected abstract List<String> resourceFilesToInstall();
}

