/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.io;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.ItemType;
import com.emc.mongoose.base.item.io.CsvFileItemInput;
import com.emc.mongoose.base.item.io.StorageItemInput;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.file.BinFileInput;
import com.github.akurilov.commons.io.file.FileInput;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Level;

public interface ItemInputFactory {
    public static <I extends Item, O extends Operation<I>> Input<I> createItemInput(Config itemConfig, int batchSize, StorageDriver<I, O> storageDriver) {
        Input<I> itemInput = null;
        ItemType itemType = ItemType.valueOf(itemConfig.stringVal("type").toUpperCase());
        Object itemFactory = ItemType.getItemFactory(itemType);
        Config itemInputConfig = itemConfig.configVal("input");
        String itemInputFile = itemInputConfig.stringVal("file");
        if (itemInputFile != null && !itemInputFile.isEmpty()) {
            itemInput = ItemInputFactory.createFileItemInput(itemFactory, itemInputFile);
            Loggers.MSG.debug("Using the file \"{}\" as items input", (Object)itemInputFile);
        } else {
            String itemInputPath = itemInputConfig.stringVal("path");
            if (itemInputPath != null && !itemInputPath.isEmpty()) {
                itemInput = ItemInputFactory.createPathItemInput(itemConfig, batchSize, itemFactory, itemInputPath, storageDriver);
                Loggers.MSG.debug("Using the storage path \"{}\" as items input", (Object)itemInputPath);
            }
        }
        return itemInput;
    }

    public static <I extends Item> Input<I> createFileItemInput(ItemFactory<I> itemFactory, String itemInputFile) {
        FileInput<Object> fileItemInput;
        block5: {
            fileItemInput = null;
            Path itemInputFilePath = Paths.get(itemInputFile, new String[0]);
            try {
                if (itemInputFile.endsWith(".csv")) {
                    try {
                        fileItemInput = new CsvFileItemInput<I>(itemInputFilePath, itemFactory);
                        break block5;
                    }
                    catch (NoSuchMethodException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                fileItemInput = new BinFileInput(itemInputFilePath);
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "Failed to open the item input file \"{}\"", itemInputFile);
            }
        }
        return fileItemInput;
    }

    public static <I extends Item, O extends Operation<I>> Input<I> createPathItemInput(Config itemConfig, int batchSize, ItemFactory<I> itemFactory, String itemInputPath, StorageDriver<I, O> storageDriver) {
        StorageItemInput<I> itemInput = null;
        try {
            Config namingConfig = itemConfig.configVal("naming");
            String prefix = namingConfig.stringVal("prefix");
            int radix = namingConfig.intVal("radix");
            itemInput = new StorageItemInput<I>(storageDriver, batchSize, itemFactory, itemInputPath, prefix, radix);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LogUtil.exception(Level.WARN, e, "Failed to initialize the data input", new Object[0]);
        }
        return itemInput;
    }
}

