/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.storage.Credential;

public interface Operation<I extends Item> {
    public static final long START_OFFSET_MICROS = System.currentTimeMillis() * 1000L - System.nanoTime() / 1000L;
    public static final String SLASH = "/";

    public int originIndex();

    public OpType type();

    public I item();

    public String nodeAddr();

    public void nodeAddr(String var1);

    public Status status();

    public void status(Status var1);

    public String srcPath();

    public void srcPath(String var1);

    public String dstPath();

    public void dstPath(String var1);

    public Credential credential();

    public void credential(Credential var1);

    public void startRequest() throws IllegalStateException;

    public void finishRequest() throws IllegalStateException;

    public void startResponse() throws IllegalStateException;

    public void finishResponse() throws IllegalStateException;

    public long reqTimeStart();

    public long reqTimeDone();

    public long respTimeStart();

    public long respTimeDone();

    public long duration();

    public long latency();

    default public void buildItemPath(I item, String itemPath) {
        String itemName = item.name();
        if (itemPath == null || itemPath.isEmpty()) {
            if (!itemName.startsWith(SLASH)) {
                item.name(SLASH + itemName);
            }
        } else if (!itemName.startsWith(itemPath)) {
            if (itemPath.endsWith(SLASH)) {
                item.name(itemPath + itemName);
            } else {
                item.name(itemPath + SLASH + itemName);
            }
        }
    }

    public <O extends Operation<I>> O result();

    public void reset();

    public static enum Status {
        PENDING,
        ACTIVE,
        INTERRUPTED,
        FAIL_UNKNOWN,
        SUCC,
        FAIL_IO,
        FAIL_TIMEOUT,
        RESP_FAIL_UNKNOWN,
        RESP_FAIL_CLIENT,
        RESP_FAIL_SVC,
        RESP_FAIL_NOT_FOUND,
        RESP_FAIL_AUTH,
        RESP_FAIL_CORRUPT,
        RESP_FAIL_SPACE;

    }
}

