/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.item.op.composite.data;

import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.composite.data.CompositeDataOperation;
import com.emc.mongoose.base.item.op.data.DataOperationImpl;
import com.emc.mongoose.base.item.op.partial.data.PartialDataOperation;
import com.emc.mongoose.base.item.op.partial.data.PartialDataOperationImpl;
import com.emc.mongoose.base.storage.Credential;
import com.github.akurilov.commons.collection.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CompositeDataOperationImpl<I extends DataItem>
extends DataOperationImpl<I>
implements CompositeDataOperation<I> {
    private long sizeThreshold;
    private final AtomicInteger pendingSubTasksCount = new AtomicInteger(-1);
    private final Map<String, String> contextData = new HashMap<String, String>();
    private final List<PartialDataOperation<I>> subTasks = new ArrayList<PartialDataOperation<I>>();

    public CompositeDataOperationImpl() {
    }

    public CompositeDataOperationImpl(int originIndex, OpType opType, I item, String srcPath, String dstPath, Credential credential, List<Range> fixedRanges, int randomRangesCount, long sizeThreshold) {
        super(originIndex, opType, item, srcPath, dstPath, credential, fixedRanges, randomRangesCount);
        this.sizeThreshold = sizeThreshold;
    }

    protected CompositeDataOperationImpl(CompositeDataOperationImpl<I> other) {
        super(other);
        this.sizeThreshold = other.sizeThreshold;
        this.pendingSubTasksCount.set(other.pendingSubTasksCount.get());
    }

    @Override
    public final String get(String key) {
        return this.contextData.get(key);
    }

    @Override
    public final void put(String key, String value) {
        this.contextData.put(key, value);
    }

    @Override
    public final List<? extends PartialDataOperation<I>> subOperations() {
        PartialDataOperationImpl nextSubTask;
        Object nextPart;
        if (!this.subTasks.isEmpty()) {
            return this.subTasks;
        }
        int equalPartsCount = this.sizeThreshold > 0L ? (int)(this.contentSize / this.sizeThreshold) : 0;
        long tailPartSize = this.contentSize % this.sizeThreshold;
        for (int i = 0; i < equalPartsCount; ++i) {
            nextPart = ((DataItem)this.item).slice((long)i * this.sizeThreshold, this.sizeThreshold);
            nextSubTask = new PartialDataOperationImpl(this.originIndex, this.opType, nextPart, this.srcPath, this.dstPath, this.credential, i, this);
            nextSubTask.srcPath(this.srcPath);
            this.subTasks.add(nextSubTask);
        }
        if (tailPartSize > 0L) {
            nextPart = ((DataItem)this.item).slice((long)equalPartsCount * this.sizeThreshold, tailPartSize);
            nextSubTask = new PartialDataOperationImpl(this.originIndex, this.opType, nextPart, this.srcPath, this.dstPath, this.credential, equalPartsCount, this);
            nextSubTask.srcPath(this.srcPath);
            this.subTasks.add(nextSubTask);
        }
        this.pendingSubTasksCount.set(this.subTasks.size());
        return this.subTasks;
    }

    @Override
    public final void markSubTaskCompleted() {
        this.pendingSubTasksCount.decrementAndGet();
    }

    @Override
    public final boolean allSubOperationsDone() {
        return this.pendingSubTasksCount.get() == 0;
    }

    @Override
    public final CompositeDataOperationImpl<I> result() {
        this.buildItemPath((DataItem)this.item, this.dstPath == null ? this.srcPath : this.dstPath);
        return new CompositeDataOperationImpl<I>(this);
    }
}

