/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step;

import com.emc.mongoose.base.Constants;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.LoadStepFactory;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.logging.log4j.Level;

public interface ScenarioUtil {
    public static final String DEFAULT_LANG = "js";

    public static ScriptEngineManager scriptEngineManager(ClassLoader clsLoader) {
        return new ScriptEngineManager(clsLoader);
    }

    public static ScriptEngine defaultScriptEngine(ScriptEngineManager sem) {
        return sem.getEngineByName(DEFAULT_LANG);
    }

    public static ScriptEngine scriptEngineByFilePath(Path scenarioPath, ClassLoader clsLoader) {
        ScriptEngine se = null;
        ScriptEngineManager sem = ScenarioUtil.scriptEngineManager(clsLoader);
        String scenarioFileName = scenarioPath.getFileName().toString();
        int dotPos = scenarioFileName.lastIndexOf(46);
        if (dotPos > 0) {
            String scenarioFileExt = scenarioFileName.substring(dotPos + 1);
            se = sem.getEngineByExtension(scenarioFileExt);
        }
        if (se == null) {
            try {
                String scenarioMimeType = Files.probeContentType(scenarioPath);
                if (scenarioMimeType != null) {
                    se = sem.getEngineByMimeType(scenarioMimeType);
                }
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "Failed to determine the content type for the scenario file \"{}\"", scenarioPath);
            }
        }
        if (se == null) {
            Loggers.MSG.info("Unable to resolve the scenario engine for the scenario file \"{}\", available scenario engines list follows:", (Object)scenarioPath);
            for (ScriptEngineFactory sef : sem.getEngineFactories()) {
                Loggers.MSG.info("\nEngine name: {}\n\tLanguage: {}\n\tFile extensions: {}\n\tMIME types: {}", (Object)sef.getEngineName(), (Object)sef.getLanguageName(), (Object)Arrays.toString(sef.getExtensions().toArray()), (Object)Arrays.toString(sef.getMimeTypes().toArray()));
            }
            se = ScenarioUtil.defaultScriptEngine(sem);
        }
        return se;
    }

    public static ScriptEngine scriptEngineByDefault(ClassLoader clsLoader) {
        return ScenarioUtil.defaultScriptEngine(ScenarioUtil.scriptEngineManager(clsLoader));
    }

    public static void registerScenarioDefaults(ScriptEngine scriptEngine, Config defaults) {
        scriptEngine.getContext().setAttribute("config", defaults, 100);
    }

    public static void registerStepTypes(ScriptEngine se, List<Extension> extensions, Config config, MetricsManager metricsMgr) {
        List<LoadStepFactory> loadStepFactories = extensions.stream().filter(ext -> ext instanceof LoadStepFactory).map(ext -> (LoadStepFactory)ext).collect(Collectors.toList());
        loadStepFactories.forEach(factory -> se.put(factory.id(), factory.createClient(config, extensions, metricsMgr)));
        loadStepFactories.stream().filter(factory -> "Load".equals(factory.id())).findFirst().ifPresent(factory -> ScenarioUtil.registerAdditionalStepTypes(se, extensions, config, metricsMgr, factory));
    }

    public static void registerAdditionalStepTypes(ScriptEngine se, List<Extension> extensions, Config config, MetricsManager metricsMgr, LoadStepFactory baseLoadStepFactory) {
        BasicConfig specificConfig = new BasicConfig(config);
        specificConfig.val("output-metrics-average-persist", false);
        specificConfig.val("output-metrics-summary-persist", false);
        specificConfig.val("output-metrics-trace-persist", false);
        se.put("PreconditionLoad", baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
        for (OpType opType : OpType.values()) {
            specificConfig = new BasicConfig(config);
            String ioTypeName = opType.name().toLowerCase();
            specificConfig.val("load-op-type", ioTypeName);
            String stepName = ioTypeName.substring(0, 1).toUpperCase() + ioTypeName.substring(1) + "Load";
            se.put(stepName, baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
        }
        specificConfig = new BasicConfig(config);
        specificConfig.val("load-op-type", OpType.READ.name().toLowerCase());
        specificConfig.val("item-data-verify", true);
        se.put("ReadVerifyLoad", baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
        specificConfig = new BasicConfig(config);
        specificConfig.val("load-op-type", OpType.READ.name().toLowerCase());
        specificConfig.val("item-data-ranges-random", 1);
        se.put("ReadRandomRangeLoad", baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
        specificConfig = new BasicConfig(config);
        specificConfig.val("load-op-type", OpType.READ.name().toLowerCase());
        specificConfig.val("item-data-verify", true);
        specificConfig.val("item-data-ranges-random", 1);
        se.put("ReadVerifyRandomRangeLoad", baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
        specificConfig = new BasicConfig(config);
        specificConfig.val("load-op-type", OpType.UPDATE.name().toLowerCase());
        specificConfig.val("item-data-ranges-random", 1);
        se.put("UpdateRandomRangeLoad", baseLoadStepFactory.createClient(specificConfig, extensions, metricsMgr));
    }

    public static void configure(ScriptEngine se, List<Extension> extensions, Config config, MetricsManager metricsMgr) {
        ScenarioUtil.registerScenarioDefaults(se, config);
        ScenarioUtil.registerStepTypes(se, extensions, config, metricsMgr);
    }

    public static Path defaultScenarioPath(Path appHomePath) {
        return Paths.get(appHomePath.toString(), Constants.DIR_EXAMPLE_SCENARIO, DEFAULT_LANG, "default.js");
    }

    public static String defaultScenario(Path appHomePath) {
        Path scenarioPath = ScenarioUtil.defaultScenarioPath(appHomePath);
        StringBuilder strb = new StringBuilder();
        try {
            Files.lines(scenarioPath).forEach(line -> strb.append((String)line).append(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Failed to read the scenario file \"" + scenarioPath + "\""));
        }
        return strb.toString();
    }
}

