/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.load.step.file.FileManager;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public final class ItemDataInputFileSlicer
implements AutoCloseable {
    private final String loadStepId;
    private final Map<FileManager, String> itemDataInputFileSlices;

    public ItemDataInputFileSlicer(String loadStepId, List<FileManager> fileMgrs, List<Config> configSlices, String itemDataInputFile, int batchSize) {
        this.loadStepId = loadStepId;
        int sliceCount = configSlices.size();
        this.itemDataInputFileSlices = new HashMap<FileManager, String>(sliceCount);
        for (int i = 0; i < sliceCount; ++i) {
            try {
                FileManager fileMgr = fileMgrs.get(i);
                String itemDataInputFileName = fileMgr.newTmpFileName();
                this.itemDataInputFileSlices.put(fileMgr, itemDataInputFileName);
                Config configSlice = configSlices.get(i);
                configSlice.val("item-data-input-file", itemDataInputFileName);
                continue;
            }
            catch (Exception e) {
                LogUtil.exception(Level.ERROR, e, "Failed to get the item data input file name for the step slice #" + i, new Object[0]);
            }
        }
        try {
            Loggers.MSG.info("{}: distribute the data from the input file \"{}\"...", (Object)loadStepId, (Object)itemDataInputFile);
            this.distributeData(itemDataInputFile, batchSize);
        }
        catch (IOException e) {
            LogUtil.exception(Level.WARN, e, "{}: failed to use the item input", loadStepId);
        }
        catch (Throwable cause) {
            Exceptions.throwUncheckedIfInterrupted(cause);
            LogUtil.exception(Level.ERROR, cause, "{}: unexpected failure", loadStepId);
        }
    }

    @Override
    public final void close() throws Exception {
        this.itemDataInputFileSlices.entrySet().parallelStream().forEach(entry -> {
            FileManager fileMgr = (FileManager)entry.getKey();
            String itemDataInputFileName = (String)entry.getValue();
            try {
                fileMgr.deleteFile(itemDataInputFileName);
            }
            catch (Exception e) {
                Exceptions.throwUncheckedIfInterrupted(e);
                LogUtil.exception(Level.WARN, e, "{}: failed to delete the file \"{}\" @ file manager \"{}\"", this.loadStepId, itemDataInputFileName, fileMgr);
            }
        });
        this.itemDataInputFileSlices.clear();
    }

    private void distributeData(String itemDataInputFile, int batchSize) throws IOException {
        ByteBuffer bBuff = ByteBuffer.allocate(batchSize);
        try (SeekableByteChannel itemDataInput = Files.newByteChannel(Paths.get(itemDataInputFile, new String[0]), new OpenOption[0]);){
            int n;
            while (0 < (n = itemDataInput.read(bBuff))) {
                byte[] buff = new byte[n];
                bBuff.flip();
                bBuff.get(buff);
                this.itemDataInputFileSlices.entrySet().parallelStream().forEach(entry -> {
                    FileManager fileMgr = (FileManager)entry.getKey();
                    String itemDataInputFileName = (String)entry.getValue();
                    try {
                        fileMgr.writeToFile(itemDataInputFileName, buff);
                    }
                    catch (IOException e) {
                        LogUtil.exception(Level.ERROR, e, "Failed to write the data to the slice file \"{}\"", itemDataInputFile);
                    }
                });
            }
        }
    }
}

