/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.load.step.LoadStep;
import com.emc.mongoose.base.load.step.LoadStepManagerService;
import com.emc.mongoose.base.load.step.client.LoadStepClientBase;
import com.emc.mongoose.base.load.step.service.LoadStepService;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.svc.ServiceUtil;
import com.github.akurilov.confuse.Config;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public interface LoadStepSliceUtil {
    public static LoadStepService resolveRemote(Config configSlice, List<Config> ctxConfigs, String stepTypeName, String nodeAddrWithPort) {
        LoadStepService stepSvc;
        String stepSvcName;
        LoadStepManagerService stepMgrSvc;
        try {
            stepMgrSvc = (LoadStepManagerService)ServiceUtil.resolve(nodeAddrWithPort, "load/step/manager");
        }
        catch (Exception e) {
            LogUtil.exception(Level.ERROR, e, "Failed to resolve the service \"{}\" @ {}", "load/step/manager", nodeAddrWithPort);
            return null;
        }
        try {
            stepSvcName = stepMgrSvc.getStepService(stepTypeName, configSlice, ctxConfigs);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted(e);
            LogUtil.exception(Level.ERROR, e, "Failed to start the new scenario step service @ {}", nodeAddrWithPort);
            return null;
        }
        try {
            stepSvc = (LoadStepService)ServiceUtil.resolve(nodeAddrWithPort, stepSvcName);
        }
        catch (Exception e) {
            LogUtil.exception(Level.ERROR, e, "Failed to resolve the service \"{}\" @ {}", "load/step/manager", nodeAddrWithPort);
            return null;
        }
        try {
            Loggers.MSG.info("{}: load step service is resolved @ {}", (Object)stepSvc.name(), (Object)nodeAddrWithPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return stepSvc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean await(LoadStep stepSlice, long timeout, TimeUnit timeUnit) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", stepSlice.id()).put("class_name", LoadStepClientBase.class.getSimpleName());){
            long commFailCount = 0L;
            while (true) {
                try {
                    while (!stepSlice.await(timeout, timeUnit)) {
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (RemoteException e) {
                    LogUtil.exception(Level.DEBUG, e, "Failed to invoke the step slice \"{}\" await method {} times", stepSlice, commFailCount);
                    Thread.sleep(++commFailCount);
                }
            }
        }
        catch (InterruptedException e) {
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
            return false;
        }
        catch (RemoteException ignored) {
            return false;
        }
    }
}

