/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.client;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.load.step.file.FileManager;
import com.emc.mongoose.base.load.step.service.file.FileManagerService;
import com.emc.mongoose.base.logging.LogContextThreadFactory;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public class OpTraceLogFileAggregator
implements Closeable {
    private final String loadStepId;
    private final Map<FileManager, String> opTraceLogFileSlices;

    public OpTraceLogFileAggregator(String loadStepId, List<FileManager> fileMgrs) {
        this.loadStepId = loadStepId;
        this.opTraceLogFileSlices = fileMgrs.stream().filter(fileMgr -> fileMgr instanceof FileManagerService).collect(Collectors.toMap(Function.identity(), fileMgr -> {
            String ioTraceLogFileSliceName = null;
            try {
                ioTraceLogFileSliceName = fileMgr.logFileName(Loggers.OP_TRACES.getName(), loadStepId);
                Loggers.MSG.debug("{}: the remote file manager \"{}\" returned the file name \"{}\" for the I/O traces", (Object)loadStepId, fileMgr, (Object)ioTraceLogFileSliceName);
            }
            catch (IOException e) {
                LogUtil.exception(Level.WARN, e, "{}: failed to get the remote log file name", loadStepId);
            }
            return ioTraceLogFileSliceName;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collectToLocal() {
        LongAdder byteCounter = new LongAdder();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, new LogContextThreadFactory("collectOpTraceLogFileWorker", true));
        CountDownLatch finishLatch = new CountDownLatch(1);
        executor.submit(() -> {
            try {
                this.opTraceLogFileSlices.entrySet().parallelStream().filter(entry -> entry.getKey() instanceof FileManagerService).forEach(entry -> {
                    FileManager fileMgr = (FileManager)entry.getKey();
                    String remoteIoTraceLogFileName = (String)entry.getValue();
                    OpTraceLogFileAggregator.transferToLocal(fileMgr, remoteIoTraceLogFileName, byteCounter);
                    try {
                        fileMgr.deleteFile(remoteIoTraceLogFileName);
                    }
                    catch (Exception e) {
                        Exceptions.throwUncheckedIfInterrupted(e);
                        LogUtil.exception(Level.WARN, e, "{}: failed to delete the file \"{}\" @ file manager \"{}\"", this.loadStepId, remoteIoTraceLogFileName, fileMgr);
                    }
                });
            }
            finally {
                finishLatch.countDown();
            }
        });
        executor.scheduleAtFixedRate(() -> Loggers.MSG.info("\"{}\": transferred {} I/O trace data...", (Object)this.loadStepId, (Object)SizeInBytes.formatFixedSize(byteCounter.longValue())), 0L, 10000L, TimeUnit.MILLISECONDS);
        try {
            finishLatch.await();
        }
        catch (InterruptedException e) {
            com.github.akurilov.commons.lang.Exceptions.throwUnchecked(e);
        }
        finally {
            executor.shutdownNow();
            Loggers.MSG.info("\"{}\": transferred {} of the operation traces data", (Object)this.loadStepId, (Object)SizeInBytes.formatFixedSize(byteCounter.longValue()));
        }
    }

    /*
     * Exception decompiling
     */
    private static void transferToLocal(FileManager fileMgr, String remoteIoTraceLogFileName, LongAdder byteCounter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 9[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final void close() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("step_id", this.loadStepId).put("class_name", this.getClass().getSimpleName());){
            this.collectToLocal();
        }
        this.opTraceLogFileSlices.clear();
    }
}

