/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.file;

import com.emc.mongoose.base.load.step.file.FileManagerImpl;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public interface FileManager {
    public static final FileManager INSTANCE = new FileManagerImpl();
    public static final byte[] EMPTY = new byte[0];
    public static final OpenOption[] READ_OPTIONS = new OpenOption[]{StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS};
    public static final OpenOption[] WRITE_OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    public static final OpenOption[] APPEND_OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
    public static final Path TMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "mongoose");

    public String logFileName(String var1, String var2) throws IOException;

    public String newTmpFileName() throws IOException;

    public byte[] readFromFile(String var1, long var2) throws IOException;

    public void writeToFile(String var1, byte[] var2) throws IOException;

    public long fileSize(String var1) throws IOException;

    public void truncateFile(String var1, long var2) throws IOException;

    public void deleteFile(String var1) throws IOException;
}

