/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.linear;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.step.client.LoadStepClient;
import com.emc.mongoose.base.load.step.client.LoadStepClientBase;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.util.List;

public class LinearLoadStepClient
extends LoadStepClientBase {
    public LinearLoadStepClient(Config baseConfig, List<Extension> extensions, List<Config> contextConfigs, MetricsManager metricsManager) {
        super(baseConfig, extensions, contextConfigs, metricsManager);
    }

    @Override
    protected <T extends LoadStepClient> T copyInstance(Config config, List<Config> ctxConfigs) {
        return (T)new LinearLoadStepClient(config, this.extensions, ctxConfigs, this.metricsMgr);
    }

    @Override
    protected void init() throws IllegalStateException {
        String autoStepId = "linear_" + LogUtil.getDateTimeStamp();
        if (this.config.boolVal("load-step-idAutoGenerated")) {
            this.config.val("load-step-id", autoStepId);
        }
        OpType opType = OpType.valueOf(this.config.stringVal("load-op-type").toUpperCase());
        int concurrencyLimit = this.config.intVal("storage-driver-limit-concurrency");
        Config outputConfig = this.config.configVal("output");
        Config metricsConfig = outputConfig.configVal("metrics");
        Object itemDataSizeRaw = this.config.val("item-data-size");
        SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(TypeUtil.typeConvert(itemDataSizeRaw, Long.TYPE));
        boolean originIndex = false;
        boolean colorFlag = outputConfig.boolVal("color");
        this.initMetrics(0, opType, concurrencyLimit, metricsConfig, itemDataSize, colorFlag);
    }

    @Override
    public String getTypeName() {
        return "Load";
    }
}

