/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.load.step.service;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.load.step.LoadStepManagerService;
import com.emc.mongoose.base.load.step.service.LoadStepServiceImpl;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.svc.ServiceBase;
import com.github.akurilov.confuse.Config;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.logging.log4j.CloseableThreadContext;

public final class LoadStepManagerServiceImpl
extends ServiceBase
implements LoadStepManagerService {
    private final List<Extension> extensions;
    private final MetricsManager metricsMgr;

    public LoadStepManagerServiceImpl(int port, List<Extension> extensions, MetricsManager metricsMgr) {
        super(port);
        this.extensions = extensions;
        this.metricsMgr = metricsMgr;
    }

    @Override
    public final String name() {
        return "load/step/manager";
    }

    @Override
    protected final void doStart() {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put("class_name", this.getClass().getSimpleName());){
            super.doStart();
        }
    }

    @Override
    protected final void doClose() {
        Loggers.MSG.info("Service \"{}\" closed", (Object)"load/step/manager");
    }

    @Override
    public final String getStepService(String stepType, Config config, List<Config> ctxConfigs) throws RemoteException {
        LoadStepServiceImpl stepSvc = new LoadStepServiceImpl(this.port, this.extensions, stepType, config, ctxConfigs, this.metricsMgr);
        Loggers.MSG.info("New step service started @ port #{}: {}", (Object)this.port, (Object)stepSvc.name());
        return stepSvc.name();
    }
}

