/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.env.DateUtil;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.logging.LogMessageBase;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.ConcurrencyMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.DistributedAllMetricsSnapshot;
import com.emc.mongoose.base.metrics.snapshot.RateMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import java.util.Date;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;

@AsynchronouslyFormattable
public final class MetricsCsvLogMessage
extends LogMessageBase {
    private final AllMetricsSnapshot snapshot;
    private final OpType opType;
    private final int concurrencyLimit;

    public MetricsCsvLogMessage(AllMetricsSnapshot snapshot, OpType opType, int concurrencyLimit) {
        this.snapshot = snapshot;
        this.opType = opType;
        this.concurrencyLimit = concurrencyLimit;
    }

    @Override
    public final void formatTo(StringBuilder strb) {
        ConcurrencyMetricSnapshot concurrencySnapshot = this.snapshot.concurrencySnapshot();
        TimingMetricSnapshot durationSnapshot = this.snapshot.durationSnapshot();
        RateMetricSnapshot successCountSnapshot = this.snapshot.successSnapshot();
        RateMetricSnapshot byteCountSnapshot = this.snapshot.byteSnapshot();
        TimingMetricSnapshot latencySnapshot = this.snapshot.latencySnapshot();
        strb.append('\"').append(DateUtil.FMT_DATE_ISO8601.format(new Date())).append('\"').append(',').append(this.opType.name()).append(',').append(this.concurrencyLimit).append(',').append(this.snapshot instanceof DistributedAllMetricsSnapshot ? ((DistributedAllMetricsSnapshot)this.snapshot).nodeCount() : 1).append(',').append(concurrencySnapshot.last()).append(',').append(concurrencySnapshot.mean()).append(',').append(successCountSnapshot.count()).append(',').append(this.snapshot.failsSnapshot().count()).append(',').append(byteCountSnapshot.count()).append(',').append((double)this.snapshot.elapsedTimeMillis() / 1000.0).append(',').append((double)durationSnapshot.sum() / 1000000.0).append(',').append(successCountSnapshot.mean()).append(',').append(successCountSnapshot.last()).append(',').append(byteCountSnapshot.mean()).append(',').append(byteCountSnapshot.last()).append(',').append(durationSnapshot.mean()).append(',').append(durationSnapshot.min()).append(',').append(durationSnapshot.histogramSnapshot().quantile(0.25)).append(',').append(durationSnapshot.histogramSnapshot().quantile(0.5)).append(',').append(durationSnapshot.histogramSnapshot().quantile(0.75)).append(',').append(durationSnapshot.max()).append(',').append(latencySnapshot.mean()).append(',').append(latencySnapshot.min()).append(',').append(latencySnapshot.histogramSnapshot().quantile(0.25)).append(',').append(latencySnapshot.histogramSnapshot().quantile(0.5)).append(',').append(latencySnapshot.histogramSnapshot().quantile(0.75)).append(',').append(latencySnapshot.max());
    }
}

