/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.logging;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.logging.LogMessageBase;
import com.emc.mongoose.base.metrics.snapshot.DistributedAllMetricsSnapshot;
import com.github.akurilov.commons.system.SizeInBytes;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;

@AsynchronouslyFormattable
public class StepResultsMetricsLogMessage
extends LogMessageBase {
    private final OpType opType;
    private final String stepId;
    private final int concurrencyLimit;
    private final DistributedAllMetricsSnapshot snapshot;

    public StepResultsMetricsLogMessage(OpType opType, String stepId, int concurrencyLimit, DistributedAllMetricsSnapshot snapshot) {
        this.opType = opType;
        this.stepId = stepId;
        this.snapshot = snapshot;
        this.concurrencyLimit = concurrencyLimit;
    }

    @Override
    public final void formatTo(StringBuilder buff) {
        String lineSep = System.lineSeparator();
        buff.append("---").append(lineSep).append("# Results ##############################################################################################################").append(lineSep).append("- Load Step Id:                ").append(this.stepId).append(lineSep).append("  Operation Type:              ").append((Object)this.opType).append(lineSep).append("  Node Count:                  ").append(this.snapshot.nodeCount()).append(lineSep).append("  Concurrency:                 ").append(lineSep).append("    Limit Per Storage Driver:  ").append(this.concurrencyLimit).append(lineSep).append("    Actual:                    ").append(lineSep).append("      Last:                    ").append(this.snapshot.concurrencySnapshot().last()).append(lineSep).append("      Mean:                    ").append(this.snapshot.concurrencySnapshot().mean()).append(lineSep).append("  Operations Count:            ").append(lineSep).append("    Successful:                ").append(this.snapshot.successSnapshot().count()).append(lineSep).append("    Failed:                    ").append(this.snapshot.failsSnapshot().count()).append(lineSep).append("  Transfer Size:               ").append(SizeInBytes.formatFixedSize(this.snapshot.byteSnapshot().count())).append(lineSep).append("  Duration [s]:                ").append(lineSep).append("    Elapsed:                   ").append((double)this.snapshot.elapsedTimeMillis() / 1000.0).append(lineSep).append("    Sum:                       ").append((double)this.snapshot.durationSnapshot().sum() / 1000000.0).append(lineSep).append("  Throughput [op/s]:           ").append(lineSep).append("    Last:                      ").append(this.snapshot.successSnapshot().last()).append(lineSep).append("    Mean:                      ").append(this.snapshot.successSnapshot().mean()).append(lineSep).append("  Bandwidth [MB/s]:            ").append(lineSep).append("    Last:                      ").append(this.snapshot.byteSnapshot().last() / 1048576.0).append(lineSep).append("    Mean:                      ").append(this.snapshot.byteSnapshot().mean() / 1048576.0).append(lineSep).append("  Operations Duration [us]:    ").append(lineSep).append("    Avg:                       ").append(this.snapshot.durationSnapshot().mean()).append(lineSep).append("    Min:                       ").append(this.snapshot.durationSnapshot().min()).append(lineSep).append("    LoQ:                       ").append(this.snapshot.durationSnapshot().histogramSnapshot().quantile(0.25)).append(lineSep).append("    Med:                       ").append(this.snapshot.durationSnapshot().histogramSnapshot().quantile(0.5)).append(lineSep).append("    HiQ:                       ").append(this.snapshot.durationSnapshot().histogramSnapshot().quantile(0.75)).append(lineSep).append("    Max:                       ").append(this.snapshot.durationSnapshot().max()).append(lineSep).append("  Operations Latency [us]:     ").append(lineSep).append("    Avg:                       ").append(this.snapshot.latencySnapshot().mean()).append(lineSep).append("    Min:                       ").append(this.snapshot.latencySnapshot().min()).append(lineSep).append("    LoQ:                       ").append(this.snapshot.latencySnapshot().histogramSnapshot().quantile(0.25)).append(lineSep).append("    Med:                       ").append(this.snapshot.latencySnapshot().histogramSnapshot().quantile(0.5)).append(lineSep).append("    HiQ:                       ").append(this.snapshot.latencySnapshot().histogramSnapshot().quantile(0.75)).append(lineSep).append("    Max:                       ").append(this.snapshot.latencySnapshot().max()).append(lineSep).append("...").append(lineSep);
    }
}

