/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.context;

import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.metrics.snapshot.AllMetricsSnapshot;
import com.github.akurilov.commons.system.SizeInBytes;

public abstract class MetricsContextBase<S extends AllMetricsSnapshot>
implements MetricsContext<S> {
    protected final long ts = System.nanoTime();
    protected final String id;
    protected final OpType opType;
    protected final int concurrencyLimit;
    protected final int concurrencyThreshold;
    protected final SizeInBytes itemDataSize;
    protected final boolean stdOutColorFlag;
    protected final long outputPeriodMillis;
    protected final String comment;
    private volatile long tsStart = -1L;
    private volatile long lastOutputTs = 0L;
    private volatile boolean thresholdStateExitedFlag = false;
    protected volatile MetricsContextBase thresholdMetricsCtx = null;
    protected volatile S lastSnapshot = null;

    protected MetricsContextBase(String id, OpType opType, int concurrencyLimit, int nodeCount, int concurrencyThreshold, SizeInBytes itemDataSize, boolean stdOutColorFlag, long outputPeriodMillis, String comment) {
        this.id = id;
        this.opType = opType;
        this.concurrencyLimit = concurrencyLimit;
        this.concurrencyThreshold = concurrencyThreshold > 0 ? concurrencyThreshold : Integer.MAX_VALUE;
        this.itemDataSize = itemDataSize;
        this.stdOutColorFlag = stdOutColorFlag;
        this.outputPeriodMillis = outputPeriodMillis;
        this.comment = comment;
    }

    @Override
    public void start() {
        this.tsStart = System.currentTimeMillis();
    }

    @Override
    public final boolean isStarted() {
        return this.tsStart > -1L;
    }

    @Override
    public final long startTimeStamp() {
        return this.tsStart;
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final OpType opType() {
        return this.opType;
    }

    @Override
    public final int concurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Override
    public final int concurrencyThreshold() {
        return this.concurrencyThreshold;
    }

    @Override
    public final SizeInBytes itemDataSize() {
        return this.itemDataSize;
    }

    @Override
    public final boolean stdOutColorEnabled() {
        return this.stdOutColorFlag;
    }

    @Override
    public final long outputPeriodMillis() {
        return this.outputPeriodMillis;
    }

    @Override
    public final long lastOutputTs() {
        return this.lastOutputTs;
    }

    @Override
    public final void lastOutputTs(long ts) {
        this.lastOutputTs = ts;
    }

    @Override
    public final S lastSnapshot() {
        if (this.lastSnapshot == null) {
            this.refreshLastSnapshot();
        }
        return this.lastSnapshot;
    }

    @Override
    public void refreshLastSnapshot() {
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.refreshLastSnapshot();
        }
    }

    @Override
    public final MetricsContext thresholdMetrics() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Nested metrics context is not exist");
        }
        return this.thresholdMetricsCtx;
    }

    @Override
    public final void enterThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx != null) {
            throw new IllegalStateException("Nested metrics context already exists");
        }
        this.thresholdMetricsCtx = this.newThresholdMetricsContext();
        this.thresholdMetricsCtx.start();
    }

    protected abstract MetricsContextBase<S> newThresholdMetricsContext();

    @Override
    public final boolean thresholdStateEntered() {
        return this.thresholdMetricsCtx != null && this.thresholdMetricsCtx.isStarted();
    }

    @Override
    public final void exitThresholdState() throws IllegalStateException {
        if (this.thresholdMetricsCtx == null) {
            throw new IllegalStateException("Threshold state was not entered");
        }
        this.thresholdMetricsCtx.close();
        this.thresholdStateExitedFlag = true;
    }

    @Override
    public final boolean thresholdStateExited() {
        return this.thresholdStateExitedFlag;
    }

    public final int hashCode() {
        return (int)this.ts;
    }

    @Override
    public final int compareTo(MetricsContext<S> other) {
        return Long.compare(this.hashCode(), other.hashCode());
    }

    @Override
    public void close() {
        this.tsStart = -1L;
        this.lastSnapshot = null;
        if (this.thresholdMetricsCtx != null) {
            this.thresholdMetricsCtx.close();
            this.thresholdMetricsCtx = null;
        }
    }

    @Override
    public long elapsedTimeMillis() {
        return System.currentTimeMillis() - this.tsStart;
    }

    @Override
    public String comment() {
        return this.comment;
    }
}

