/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.base.metrics.type;

import com.emc.mongoose.base.metrics.snapshot.HistogramSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshot;
import com.emc.mongoose.base.metrics.snapshot.TimingMetricSnapshotImpl;
import com.emc.mongoose.base.metrics.type.LongMeter;
import java.util.concurrent.atomic.LongAdder;

public class TimingMeterImpl
implements LongMeter<TimingMetricSnapshot> {
    private final LongMeter<HistogramSnapshot> histogram;
    private final LongAdder count = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private volatile long min = Long.MAX_VALUE;
    private volatile long max = Long.MIN_VALUE;
    private final String metricName;

    public TimingMeterImpl(LongMeter<HistogramSnapshot> histogram, String metricName) {
        this.histogram = histogram;
        this.metricName = metricName;
    }

    @Override
    public void update(long value) {
        this.histogram.update(value);
        this.count.increment();
        this.sum.add(value);
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
    }

    @Override
    public TimingMetricSnapshotImpl snapshot() {
        if (this.count.sum() == 0L) {
            return new TimingMetricSnapshotImpl(0L, 0L, 0L, 0L, 0.0, this.histogram.snapshot(), this.metricName);
        }
        return new TimingMetricSnapshotImpl(this.sum.sum(), this.count.sum(), this.min, this.max, (double)this.sum.sum() / (double)this.count.sum(), this.histogram.snapshot(), this.metricName);
    }
}

