/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import com.github.akurilov.commons.collection.InvalidRangeException;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Range
implements Externalizable {
    private long beg;
    private long end;
    private long size;

    public Range() {
    }

    public Range(Range other) {
        this.beg = other.getBeg();
        this.end = other.getEnd();
        this.size = other.getSize();
    }

    public Range(long beg, long end, long size) {
        this.beg = beg;
        this.end = end;
        this.size = size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Range(String rawRange) throws InvalidRangeException, NumberFormatException {
        if (rawRange.startsWith("-")) {
            if (rawRange.endsWith("-")) {
                if (rawRange.length() <= 2) throw new InvalidRangeException("Invalid range string: \"" + rawRange + "\"");
                this.end = -1L;
                this.beg = -1L;
                this.size = SizeInBytes.toFixedSize(rawRange.substring(1, rawRange.length() - 1));
                return;
            } else {
                if (rawRange.length() <= 1) throw new InvalidRangeException("Invalid range string: \"" + rawRange + "\"");
                this.beg = -1L;
                this.end = SizeInBytes.toFixedSize(rawRange.substring(1));
                this.size = -1L;
            }
            return;
        } else if (rawRange.endsWith("-")) {
            if (rawRange.length() <= 1) throw new InvalidRangeException("Invalid range string: \"" + rawRange + "\"");
            this.beg = SizeInBytes.toFixedSize(rawRange.substring(0, rawRange.length() - 1));
            this.end = -1L;
            this.size = -1L;
            return;
        } else {
            if (!rawRange.contains("-")) throw new InvalidRangeException("Invalid range string: \"" + rawRange + "\"");
            String[] pair = rawRange.split("-");
            if (pair.length != 2) throw new InvalidRangeException("Invalid range string: \"" + rawRange + "\"");
            this.beg = SizeInBytes.toFixedSize(pair[0]);
            this.end = SizeInBytes.toFixedSize(pair[1]);
            this.size = -1L;
        }
    }

    public final long getBeg() {
        return this.beg;
    }

    public final long getEnd() {
        return this.end;
    }

    public final long getSize() {
        return this.size;
    }

    public final String toString() {
        if (this.beg == -1L) {
            if (this.end == -1L) {
                return "-" + this.size + "-";
            }
            return "-" + this.end;
        }
        if (this.end == -1L) {
            return this.beg + "-";
        }
        return this.beg + "-" + this.end;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.beg);
        out.writeLong(this.end);
        out.writeLong(this.size);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.beg = in.readLong();
        this.end = in.readLong();
        this.size = in.readLong();
    }
}

