/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface TreeUtil {
    public static Map<String, Object> copyTree(Map<String, Object> srcTree) {
        HashMap<String, Object> dstTree = new HashMap<String, Object>(srcTree.size());
        srcTree.forEach((k, v) -> dstTree.put((String)k, v instanceof Map ? TreeUtil.copyTree(v) : v));
        return dstTree;
    }

    public static Map<String, Object> addBranches(Map<String, Object> dst, Map<String, Object> src) {
        src.forEach((k, v) -> {
            if (v instanceof Map) {
                Object dstNode = dst.get(k);
                if (dstNode instanceof Map) {
                    TreeUtil.addBranches((Map)dstNode, (Map)v);
                } else {
                    dst.put((String)k, v);
                }
            } else {
                dst.put((String)k, v);
            }
        });
        return dst;
    }

    public static Map<String, Object> reduceForest(List<Map<String, Object>> forest) {
        return forest.stream().reduce(TreeUtil::addBranches).orElseGet(Collections::emptyMap);
    }
}

