/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.concurrent;

import com.github.akurilov.commons.concurrent.AsyncRunnable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class AsyncRunnableBase
implements AsyncRunnable {
    private static final Logger LOG = Logger.getLogger(AsyncRunnableBase.class.getName());
    private volatile AsyncRunnable.State state = AsyncRunnable.State.INITIAL;
    private final Lock stateLock = new ReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();

    @Override
    public final AsyncRunnable.State state() {
        return this.state;
    }

    @Override
    public boolean isInitial() {
        return AsyncRunnable.State.INITIAL == this.state;
    }

    @Override
    public boolean isStarted() {
        return AsyncRunnable.State.STARTED == this.state;
    }

    @Override
    public boolean isShutdown() {
        return AsyncRunnable.State.SHUTDOWN == this.state;
    }

    @Override
    public boolean isStopped() {
        return AsyncRunnable.State.STOPPED == this.state;
    }

    @Override
    public boolean isClosed() {
        return AsyncRunnable.State.CLOSED == this.state;
    }

    @Override
    public final AsyncRunnableBase start() {
        this.stateLock.lock();
        try {
            if (this.state == AsyncRunnable.State.INITIAL || this.state == AsyncRunnable.State.STOPPED) {
                this.doStart();
                this.state = AsyncRunnable.State.STARTED;
                this.stateChanged.signalAll();
            } else {
                LOG.warning("Not allowed to start while state is \"" + this.state + "\"");
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase shutdown() {
        this.stateLock.lock();
        try {
            if (this.state == AsyncRunnable.State.STARTED || this.state == AsyncRunnable.State.INITIAL) {
                this.doShutdown();
                this.state = AsyncRunnable.State.SHUTDOWN;
                this.stateChanged.signalAll();
            } else {
                LOG.warning("Not allowed to shutdown while state is \"" + this.state + "\"");
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase stop() {
        this.shutdown();
        this.stateLock.lock();
        try {
            if (this.state == AsyncRunnable.State.SHUTDOWN) {
                this.doStop();
                this.state = AsyncRunnable.State.STOPPED;
                this.stateChanged.signalAll();
            } else {
                LOG.warning("Not allowed to stop while state is \"" + this.state + "\"");
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return this;
    }

    @Override
    public final AsyncRunnableBase await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long elapsedTimeMillis;
        long invokeTimeMillis = System.currentTimeMillis();
        long timeOutMillis = timeUnit.toMillis(timeout);
        while (timeOutMillis > (elapsedTimeMillis = System.currentTimeMillis() - invokeTimeMillis)) {
            if (this.state != AsyncRunnable.State.STARTED && this.state != AsyncRunnable.State.SHUTDOWN) {
                return true;
            }
            if (!this.stateLock.tryLock(timeOutMillis - elapsedTimeMillis, TimeUnit.MILLISECONDS)) continue;
            try {
                elapsedTimeMillis = System.currentTimeMillis() - invokeTimeMillis;
                if (timeOutMillis > elapsedTimeMillis) {
                    if (!this.stateChanged.await(timeOutMillis - elapsedTimeMillis, TimeUnit.MILLISECONDS) || this.state == AsyncRunnable.State.STARTED || this.state == AsyncRunnable.State.SHUTDOWN) continue;
                    boolean bl = true;
                    return bl;
                }
                break;
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return this.state != AsyncRunnable.State.STARTED && this.state != AsyncRunnable.State.SHUTDOWN;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.stateLock.lock();
        try {
            if (this.state != AsyncRunnable.State.CLOSED) {
                this.doClose();
                this.state = AsyncRunnable.State.CLOSED;
                this.stateChanged.signalAll();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected void doStart() {
    }

    protected void doShutdown() {
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }
}

