/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.EOFException;
import java.util.List;

public class ArrayInput<T>
implements Input<T> {
    protected final T[] items;
    protected int size;
    protected int i = 0;

    public ArrayInput(T[] items) {
        this.items = items;
        this.size = items.length;
    }

    @Override
    public T get() {
        if (this.i < this.size) {
            return this.items[this.i++];
        }
        Exceptions.throwUnchecked(new EOFException());
        return null;
    }

    @Override
    public int get(List<T> buffer, int maxCount) {
        int n = this.size - this.i;
        if (n > 0) {
            n = Math.min(n, maxCount);
            for (int j = this.i; j < this.i + n; ++j) {
                buffer.add(this.items[j]);
            }
        } else {
            Exceptions.throwUnchecked(new EOFException());
        }
        this.i += n;
        return n;
    }

    @Override
    public long skip(long itemsCount) {
        int remainingCount = this.size - this.i;
        if (itemsCount > (long)remainingCount) {
            this.i = 0;
            return remainingCount;
        }
        this.i += (int)itemsCount;
        return itemsCount;
    }

    @Override
    public void reset() {
        this.i = 0;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "arrayInput<" + this.items.hashCode() + ">";
    }
}

