/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.lang.Exceptions;
import java.util.Arrays;
import java.util.List;

public final class CompositeStringInput
implements Input<String> {
    private static final ThreadLocal<StringBuilder> STR_BUILDER = ThreadLocal.withInitial(StringBuilder::new);
    private final Object[] segments;
    private final int count;

    public CompositeStringInput(Object[] segments) {
        this.segments = segments;
        this.count = segments.length;
    }

    @Override
    public final String get() {
        StringBuilder strBuilder = STR_BUILDER.get();
        for (int i = 0; i < this.count; ++i) {
            Object v;
            Object segment = this.segments[i];
            if (segment instanceof String) {
                strBuilder.append((String)segment);
                continue;
            }
            if (!(segment instanceof Input) || null == (v = ((Input)segment).get())) continue;
            if (v instanceof String) {
                strBuilder.append(v);
                continue;
            }
            strBuilder.append(v.toString());
        }
        String result = strBuilder.toString();
        strBuilder.setLength(0);
        return result;
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        for (int i = 0; i < limit; ++i) {
            buffer.add(this.get());
        }
        return limit;
    }

    @Override
    public final long skip(long count) {
        Arrays.stream(this.segments).filter(segment -> segment instanceof Input).map(segment -> (Input)segment).forEach(input -> input.skip(count));
        return count;
    }

    @Override
    public final void reset() {
        Arrays.stream(this.segments).filter(segment -> segment instanceof Input).map(segment -> (Input)segment).forEach(Input::reset);
    }

    @Override
    public final void close() {
        for (int i = 0; i < this.count; ++i) {
            Object segment = this.segments[i];
            this.segments[i] = null;
            if (!(segment instanceof Input)) continue;
            try {
                ((Input)segment).close();
                continue;
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }
}

