/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.collection.IoBuffer;
import com.github.akurilov.commons.lang.Exceptions;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class LimitedQueueBuffer<T>
implements IoBuffer<T> {
    private T lastItem = null;
    protected final BlockingQueue<T> queue;

    public LimitedQueueBuffer(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public boolean put(T item) {
        return this.queue.offer(item);
    }

    @Override
    public int put(List<T> buffer, int from, int to) {
        int i;
        for (i = from; i < to && this.queue.offer(buffer.get(i)); ++i) {
        }
        return i - from;
    }

    @Override
    public final int put(List<T> items) {
        return this.put(items, 0, items.size());
    }

    @Override
    public LimitedQueueBuffer<T> getInput() {
        return this;
    }

    @Override
    public T get() {
        return (T)this.queue.poll();
    }

    @Override
    public int get(List<T> buffer, int maxCount) throws UnsupportedOperationException, IllegalArgumentException {
        return this.queue.drainTo(buffer, maxCount);
    }

    @Override
    public long skip(long itemsCount) {
        try {
            T item;
            long i;
            for (i = 0L; i < itemsCount && !(item = this.queue.take()).equals(this.lastItem); ++i) {
            }
            return i;
        }
        catch (InterruptedException e) {
            Exceptions.throwUnchecked(e);
            return 0L;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public final int size() {
        return this.queue.size();
    }

    @Override
    public void reset() {
    }

    @Override
    public void close() {
        this.queue.clear();
    }

    public String toString() {
        return "queueBuffer#" + this.hashCode();
    }
}

