/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.el;

import com.github.akurilov.commons.io.el.ExpressionInput;
import com.github.akurilov.commons.io.el.ExpressionInputImpl;
import com.github.akurilov.commons.io.el.SynchronousExpressionInputImpl;
import com.github.akurilov.commons.lang.Exceptions;
import de.odysseus.el.util.SimpleContext;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import javax.el.ValueExpression;

public class ExpressionInputBuilder
implements ExpressionInput.Builder {
    protected final SimpleContext ctx = new SimpleContext();
    protected volatile String expr = null;

    @Override
    public final ExpressionInput.Builder expression(String expr) {
        this.expr = expr;
        return this;
    }

    @Override
    public final ExpressionInput.Builder function(String prefix, String name, Method method) {
        this.ctx.setFunction(prefix, name, method);
        return this;
    }

    @Override
    public final ExpressionInput.Builder value(String name, Object val, Class<?> type) {
        ValueExpression ve = ExpressionInput.FACTORY.createValueExpression(val, type);
        this.ctx.setVariable(name, ve);
        return this;
    }

    @Override
    public <U extends ExpressionInput<?>> U build() {
        String fullExpr = this.expr;
        Matcher matcher = ExpressionInput.EXPRESSION_PATTERN.matcher(fullExpr);
        Object initial = null;
        if (matcher.find()) {
            String initialValExpr = matcher.group(2);
            if (initialValExpr != null) {
                this.expr = "${" + initialValExpr.substring("%{".length());
                try (U initialValueInput = this.build();){
                    initial = initialValueInput.get();
                }
                catch (Exception e) {
                    Exceptions.throwUnchecked(e);
                }
            }
            this.expr = matcher.group(1);
            if (initialValExpr == null && this.expr == null) {
                throw new IllegalArgumentException("The expression \"" + fullExpr + "\" doesn't match the pattern: " + ExpressionInput.EXPRESSION_PATTERN.pattern());
            }
        } else {
            throw new IllegalArgumentException("The expression \"" + fullExpr + "\" doesn't match the pattern: " + ExpressionInput.EXPRESSION_PATTERN.pattern());
        }
        if (null == this.expr) {
            this.expr = "";
        }
        if (!this.expr.isEmpty() && this.expr.startsWith("${")) {
            return (U)new SynchronousExpressionInputImpl<Object>(this.expr, initial, this.ctx);
        }
        return (U)new ExpressionInputImpl<Object>(this.expr, initial, this.ctx);
    }
}

