/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.BinOutput;
import com.github.akurilov.commons.io.file.BinFileInput;
import com.github.akurilov.commons.io.file.FileOutput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BinFileOutput<T>
extends BinOutput<T>
implements FileOutput<T> {
    protected final Path dstPath;

    public BinFileOutput(Path dstPath) {
        super(BinFileOutput.open(dstPath));
        this.dstPath = dstPath;
    }

    static ObjectOutputStream open(Path dstPath) {
        try {
            return new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(dstPath, OUTPUT_OPEN_OPTIONS)));
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    public BinFileOutput() {
        this(BinFileOutput.createTempFile());
        this.dstPath.toFile().deleteOnExit();
    }

    static Path createTempFile() {
        try {
            return Files.createTempFile(null, ".bin", new FileAttribute[0]);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public BinFileInput<T> getInput() {
        return new BinFileInput(this.dstPath);
    }

    @Override
    public String toString() {
        return "binFileOutput<" + this.dstPath.getFileName() + ">";
    }

    @Override
    public final Path filePath() {
        return this.dstPath;
    }
}

