/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.file;

import com.github.akurilov.commons.io.Input;
import com.github.akurilov.commons.io.TextStreamOutput;
import com.github.akurilov.commons.io.file.FileOutput;
import com.github.akurilov.commons.io.file.TextFileInput;
import com.github.akurilov.commons.lang.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TextFileOutput
extends TextStreamOutput
implements FileOutput<String> {
    private final Path filePath;

    public TextFileOutput() {
        this(TextFileOutput.createTempFile());
    }

    static Path createTempFile() {
        try {
            return Files.createTempFile(null, ".txt", new FileAttribute[0]);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    public TextFileOutput(Path filePath) {
        super(TextFileOutput.open(filePath));
        this.filePath = filePath;
    }

    static OutputStream open(Path filePath) {
        try {
            return Files.newOutputStream(filePath, OUTPUT_OPEN_OPTIONS);
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
            return null;
        }
    }

    @Override
    public Input<String> getInput() {
        return new TextFileInput(this.filePath);
    }

    @Override
    public Path filePath() {
        return this.filePath;
    }
}

