/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.confuse;

import com.github.akurilov.commons.collection.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public interface SchemaProvider {
    public String id();

    public Map<String, Object> schema() throws Exception;

    public static List<Map<String, Object>> resolve(String id, ClassLoader clsLoader) throws Exception {
        ServiceLoader<SchemaProvider> loader = ServiceLoader.load(SchemaProvider.class, clsLoader);
        ArrayList<Map<String, Object>> matchingSchemes = new ArrayList<Map<String, Object>>();
        for (SchemaProvider schemaProvider : loader) {
            if (!id.equals(schemaProvider.id())) continue;
            matchingSchemes.add(schemaProvider.schema());
        }
        return matchingSchemes;
    }

    public static Map<String, Object> resolveAndReduce(String id, ClassLoader clsLoader) throws Exception {
        return TreeUtil.reduceForest(SchemaProvider.resolve(id, clsLoader));
    }
}

